/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.common;

import org.apache.geaflow.cluster.rpc.RpcClient;
import org.apache.geaflow.cluster.rpc.impl.RpcServiceImpl;
import org.apache.geaflow.cluster.system.ClusterMetaStore;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.utils.ProcessUtil;
import org.apache.geaflow.ha.service.HAServiceFactory;
import org.apache.geaflow.ha.service.IHAService;
import org.apache.geaflow.ha.service.ResourceData;
import org.apache.geaflow.metrics.common.MetricGroupRegistry;
import org.apache.geaflow.metrics.common.api.MetricGroup;
import org.apache.geaflow.shuffle.service.ShuffleManager;
import org.apache.geaflow.stats.collector.StatsCollectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractComponent.class);
    protected int id;
    protected String name;
    protected String masterId;
    protected int rpcPort;
    protected int supervisorPort;
    protected Configuration configuration;
    protected IHAService haService;
    protected RpcServiceImpl rpcService;
    protected MetricGroup metricGroup;
    protected MetricGroupRegistry metricGroupRegistry;

    public AbstractComponent() {
    }

    public AbstractComponent(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public void init(int id, String name, Configuration configuration) {
        this.id = id;
        this.name = name;
        this.configuration = configuration;
        this.masterId = configuration.getMasterId();
        this.metricGroupRegistry = MetricGroupRegistry.getInstance((Configuration)configuration);
        this.metricGroup = this.metricGroupRegistry.getMetricGroup();
        this.haService = HAServiceFactory.getService((Configuration)configuration);
        RpcClient.init(configuration);
        ClusterMetaStore.init(id, name, configuration);
        StatsCollectorFactory.init((Configuration)configuration);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOGGER.warn("*** Shutting ClusterMetaStore since JVM is shutting down.");
            ClusterMetaStore.close();
            LOGGER.warn("*** ClusterMetaStore is shutdown.");
        }));
    }

    protected void registerHAService() {
        ResourceData resourceData = this.buildResourceData();
        LOGGER.info("register {}: {}", (Object)this.name, (Object)resourceData);
        this.haService.register(this.name, resourceData);
    }

    protected ResourceData buildResourceData() {
        ResourceData resourceData = new ResourceData();
        resourceData.setProcessId(ProcessUtil.getProcessId());
        resourceData.setHost(ProcessUtil.getHostIp());
        resourceData.setRpcPort(this.rpcPort);
        ShuffleManager shuffleManager = ShuffleManager.getInstance();
        if (shuffleManager != null) {
            resourceData.setShufflePort(shuffleManager.getShufflePort());
        }
        return resourceData;
    }

    public void close() {
        if (this.haService != null) {
            this.haService.close();
        }
        if (this.rpcService != null) {
            this.rpcService.stopService();
        }
        ClusterMetaStore.close();
    }

    public void waitTermination() {
        this.rpcService.waitTermination();
    }
}

