/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.collector;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.geaflow.cluster.collector.EmitterRunner;
import org.apache.geaflow.cluster.collector.IEmitterRequest;
import org.apache.geaflow.cluster.task.service.AbstractTaskService;
import org.apache.geaflow.common.config.Configuration;

public class EmitterService
extends AbstractTaskService<IEmitterRequest, EmitterRunner>
implements Serializable {
    private static final String EMITTER_FORMAT = "geaflow-emitter-%d";
    private final int slots;

    public EmitterService(int slots, Configuration configuration) {
        super(configuration, EMITTER_FORMAT);
        this.slots = slots;
    }

    protected EmitterRunner[] buildTaskRunner() {
        Preconditions.checkArgument((this.slots > 0 ? 1 : 0) != 0, (Object)"fetcher pool should be larger than 0");
        EmitterRunner[] emitterRunners = new EmitterRunner[this.slots];
        for (int i = 0; i < this.slots; ++i) {
            EmitterRunner runner;
            emitterRunners[i] = runner = new EmitterRunner(this.configuration, i);
        }
        return emitterRunners;
    }
}

