/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.collector;

import org.apache.geaflow.cluster.collector.CloseEmitterRequest;
import org.apache.geaflow.cluster.collector.IEmitterRequest;
import org.apache.geaflow.cluster.collector.InitEmitterRequest;
import org.apache.geaflow.cluster.collector.PipelineOutputEmitter;
import org.apache.geaflow.cluster.collector.StashEmitterRequest;
import org.apache.geaflow.cluster.collector.UpdateEmitterRequest;
import org.apache.geaflow.cluster.task.runner.AbstractTaskRunner;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.errorcode.RuntimeErrors;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;

public class EmitterRunner
extends AbstractTaskRunner<IEmitterRequest> {
    private final PipelineOutputEmitter outputEmitter;

    public EmitterRunner(Configuration configuration, int index) {
        this.outputEmitter = new PipelineOutputEmitter(configuration, index);
    }

    @Override
    protected void process(IEmitterRequest request) {
        switch (request.getRequestType()) {
            case INIT: {
                this.outputEmitter.init((InitEmitterRequest)request);
                break;
            }
            case POP: {
                this.outputEmitter.update((UpdateEmitterRequest)request);
                break;
            }
            case CLOSE: {
                this.outputEmitter.close((CloseEmitterRequest)request);
                break;
            }
            case STASH: {
                this.outputEmitter.stash((StashEmitterRequest)request);
                break;
            }
            case CLEAR: {
                this.outputEmitter.clear();
                break;
            }
            default: {
                throw new GeaflowRuntimeException(RuntimeErrors.INST.requestTypeNotSupportError(request.getRequestType().name()));
            }
        }
    }
}

