/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.collector;

import org.apache.geaflow.api.context.RuntimeContext;
import org.apache.geaflow.cluster.collector.AbstractPipelineCollector;
import org.apache.geaflow.cluster.response.ShardResult;
import org.apache.geaflow.collector.IResultCollector;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.shuffle.ForwardOutputDesc;
import org.apache.geaflow.shuffle.desc.OutputType;
import org.apache.geaflow.shuffle.message.Shard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipelineOutputCollector<T>
extends AbstractPipelineCollector<T>
implements IResultCollector<ShardResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPipelineOutputCollector.class);
    private int edgeId;
    private String edgeName;
    private Shard shard;
    private OutputType collectType;

    public AbstractPipelineOutputCollector(ForwardOutputDesc outputDesc) {
        super(outputDesc);
        this.edgeName = outputDesc.getEdgeName();
        this.edgeId = outputDesc.getEdgeId();
        this.collectType = outputDesc.getType();
    }

    @Override
    public void setUp(RuntimeContext runtimeContext) {
        super.setUp(runtimeContext);
        int taskId = runtimeContext.getTaskArgs().getTaskId();
        int taskIndex = runtimeContext.getTaskArgs().getTaskIndex();
        this.shard = null;
        LOGGER.info("setup PipelineOutputCollector {} taskId {} taskIndex {} edgeName {} edgeId {}", new Object[]{this, taskId, taskIndex, this.edgeName, this.edgeId});
    }

    @Override
    public void finish() {
        try {
            this.shard = (Shard)this.outputBuffer.finish(this.windowId);
        }
        catch (Exception e) {
            throw new GeaflowRuntimeException((Throwable)e);
        }
    }

    public String getTag() {
        return this.edgeName;
    }

    public ShardResult collectResult() {
        if (this.shard == null) {
            return null;
        }
        return new ShardResult(this.shard.getEdgeId(), this.collectType, this.shard.getSlices());
    }
}

