/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.clustermanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.geaflow.cluster.container.ContainerInfo;

public class ContainerExecutorInfo
implements Serializable {
    private int containerId;
    private String containerName;
    private String host;
    private int processId;
    private int rpcPort;
    private int shufflePort;
    private List<Integer> executorIds;

    public ContainerExecutorInfo(ContainerInfo containerInfo, int firstWorkerIndex, int workerNum) {
        this.containerId = containerInfo.getId();
        this.containerName = containerInfo.getName();
        this.host = containerInfo.getHost();
        this.rpcPort = containerInfo.getRpcPort();
        this.shufflePort = containerInfo.getShufflePort();
        this.processId = containerInfo.getPid();
        this.executorIds = new ArrayList<Integer>(workerNum);
        for (int i = 0; i < workerNum; ++i) {
            this.executorIds.add(firstWorkerIndex + i);
        }
    }

    public int getContainerId() {
        return this.containerId;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getHost() {
        return this.host;
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public int getShufflePort() {
        return this.shufflePort;
    }

    public List<Integer> getExecutorIds() {
        return this.executorIds;
    }
}

