/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.clustermanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geaflow.cluster.clustermanager.ExecutorRegisteredCallback;
import org.apache.geaflow.cluster.common.IReliableContext;
import org.apache.geaflow.cluster.common.ReliableContainerContext;
import org.apache.geaflow.cluster.config.ClusterConfig;
import org.apache.geaflow.cluster.constants.ClusterConstants;
import org.apache.geaflow.cluster.heartbeat.HeartbeatManager;
import org.apache.geaflow.cluster.system.ClusterMetaStore;
import org.apache.geaflow.common.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterContext
extends ReliableContainerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterContext.class);
    private final Configuration config;
    private final ClusterConfig clusterConfig;
    private final List<ExecutorRegisteredCallback> callbacks;
    private HeartbeatManager heartbeatManager;
    private Map<Integer, String> containerIds;
    private Map<Integer, String> driverIds;
    private int maxComponentId;

    public ClusterContext(Configuration configuration) {
        super(0, ClusterConstants.getMasterName(), configuration);
        this.config = configuration;
        this.clusterConfig = ClusterConfig.build(configuration);
        this.callbacks = new ArrayList<ExecutorRegisteredCallback>();
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    public ClusterConfig getClusterConfig() {
        return this.clusterConfig;
    }

    public void addExecutorRegisteredCallback(ExecutorRegisteredCallback callback) {
        this.callbacks.add(callback);
    }

    public List<ExecutorRegisteredCallback> getCallbacks() {
        return this.callbacks;
    }

    public HeartbeatManager getHeartbeatManager() {
        return this.heartbeatManager;
    }

    public void setHeartbeatManager(HeartbeatManager heartbeatManager) {
        this.heartbeatManager = heartbeatManager;
    }

    public Map<Integer, String> getContainerIds() {
        return this.containerIds;
    }

    public void setContainerIds(Map<Integer, String> containerIds) {
        this.containerIds = containerIds;
    }

    public Map<Integer, String> getDriverIds() {
        return this.driverIds;
    }

    public void setDriverIds(Map<Integer, String> driverIds) {
        this.driverIds = driverIds;
    }

    public int getMaxComponentId() {
        return this.maxComponentId;
    }

    public void setMaxComponentId(int maxComponentId) {
        this.maxComponentId = maxComponentId;
    }

    @Override
    public void load() {
        int containerNum;
        ClusterMetaStore metaStore = ClusterMetaStore.getInstance(this.id, this.name, this.config);
        Map<Integer, String> drivers = metaStore.getDriverIds();
        Map<Integer, String> containerIds = metaStore.getContainerIds();
        int driverNum = drivers == null ? 0 : drivers.size();
        int n = containerNum = containerIds == null ? 0 : containerIds.size();
        if (driverNum != 0 && containerNum != 0) {
            this.isRecover = true;
            this.driverIds = drivers;
            this.containerIds = containerIds;
            this.maxComponentId = metaStore.getMaxContainerId();
            LOGGER.info("recover {} containers and {} drivers maxComponentId: {}", new Object[]{containerNum, driverNum, this.maxComponentId});
        } else {
            this.isRecover = false;
            this.driverIds = new ConcurrentHashMap<Integer, String>();
            this.containerIds = new ConcurrentHashMap<Integer, String>();
            this.maxComponentId = 0;
            LOGGER.info("init with maxComponentId: {}", (Object)this.maxComponentId);
        }
    }

    public void setRecover(boolean isRecovered) {
        this.isRecover = isRecovered;
    }

    public static class ClusterCheckpointFunction
    implements IReliableContext.IReliableContextCheckpointFunction {
        @Override
        public void doCheckpoint(IReliableContext context) {
            ClusterContext clusterContext = (ClusterContext)context;
            Map<Integer, String> containerIds = clusterContext.getContainerIds();
            Map<Integer, String> driverIds = clusterContext.getDriverIds();
            ClusterMetaStore metaStore = ClusterMetaStore.getInstance(clusterContext.id, clusterContext.name, clusterContext.config);
            if (containerIds != null && !containerIds.isEmpty() && driverIds != null && !driverIds.isEmpty()) {
                LOGGER.info("persist {} containers and {} drivers into metaStore", (Object)containerIds.size(), (Object)driverIds.size());
                metaStore.saveMaxContainerId(clusterContext.getMaxComponentId());
                metaStore.saveContainerIds(containerIds);
                metaStore.saveDriverIds(driverIds);
                metaStore.flush();
            }
        }
    }
}

