/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.client.callback;

import com.google.gson.Gson;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.geaflow.cluster.client.callback.JobOperatorCallback;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.config.keys.DSLConfigKeys;
import org.apache.geaflow.common.config.keys.ExecutionConfigKeys;
import org.apache.geaflow.utils.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestJobOperatorCallback
implements JobOperatorCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestJobOperatorCallback.class);
    private static final String GEAFLOW_TOKEN_KEY = "geaflow-token";
    private static final String FINISH_JOB_PATH = "/api/tasks/%s/operations";
    private static final String FINISH_ACTION_KEY = "finish";
    private final String callbackUrl;
    private final Map<String, String> headers;
    private final long uniqueId;

    public RestJobOperatorCallback(Configuration config, String url) {
        this.uniqueId = config.getLong(ExecutionConfigKeys.JOB_UNIQUE_ID);
        this.callbackUrl = url;
        this.headers = new HashMap<String, String>();
        this.headers.put(GEAFLOW_TOKEN_KEY, config.getString(DSLConfigKeys.GEAFLOW_DSL_CATALOG_TOKEN_KEY, ""));
    }

    @Override
    public void onFinish() {
        JobOperatorCallback.JobOperatorMeta jobOperatorMeta = new JobOperatorCallback.JobOperatorMeta();
        jobOperatorMeta.setSuccess(true);
        jobOperatorMeta.setAction(FINISH_ACTION_KEY);
        String fullUrl = this.getFullUrl(jobOperatorMeta);
        if (fullUrl != null) {
            HttpUtil.post((String)fullUrl, (String)new Gson().toJson((Object)jobOperatorMeta), this.headers);
        }
    }

    private String getFullUrl(JobOperatorCallback.JobOperatorMeta jobOperatorMeta) {
        String fullUrl = null;
        try {
            URI uri = new URI(this.callbackUrl);
            String path = String.format(FINISH_JOB_PATH, this.uniqueId);
            fullUrl = uri.resolve(path).toString();
        }
        catch (URISyntaxException e) {
            LOGGER.error("post {} failed: {}, msg: {}", new Object[]{fullUrl, jobOperatorMeta, e.getMessage()});
        }
        return fullUrl;
    }
}

