/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.client.callback;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.geaflow.cluster.client.callback.ClusterStartedCallback;
import org.apache.geaflow.cluster.client.callback.HttpRequest;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.config.keys.DSLConfigKeys;
import org.apache.geaflow.utils.HttpUtil;

public class RestClusterStartedCallback
implements ClusterStartedCallback {
    private static final String GEAFLOW_TOKEN_KEY = "geaflow-token";
    private final String callbackUrl;
    private final Map<String, String> headers;

    public RestClusterStartedCallback(Configuration config, String url) {
        this.callbackUrl = url;
        this.headers = new HashMap<String, String>();
        this.headers.put(GEAFLOW_TOKEN_KEY, config.getString(DSLConfigKeys.GEAFLOW_DSL_CATALOG_TOKEN_KEY, ""));
    }

    @Override
    public void onSuccess(ClusterStartedCallback.ClusterMeta clusterInfo) {
        HttpRequest request = new HttpRequest();
        request.setSuccess(true);
        request.setData(clusterInfo);
        HttpUtil.post((String)this.callbackUrl, (String)new Gson().toJson((Object)request), this.headers);
    }

    @Override
    public void onFailure(Throwable e) {
        HttpRequest request = new HttpRequest();
        request.setSuccess(false);
        request.setMessage(e.getMessage());
        HttpUtil.post((String)this.callbackUrl, (String)new Gson().toJson((Object)request), this.headers);
    }
}

