/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.client.callback;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.geaflow.cluster.clustermanager.ClusterInfo;
import org.apache.geaflow.cluster.rpc.ConnectAddress;
import org.apache.geaflow.common.utils.ProcessUtil;

public interface ClusterStartedCallback
extends Serializable {
    public void onSuccess(ClusterMeta var1);

    public void onFailure(Throwable var1);

    public static class ClusterMeta
    implements Serializable {
        private String masterAddress;
        private String clientAddress;
        private Map<String, ConnectAddress> driverAddresses;

        public ClusterMeta() {
        }

        public ClusterMeta(ClusterInfo clusterInfo) {
            this(clusterInfo.getDriverAddresses(), clusterInfo.getMasterAddress().toString());
        }

        public ClusterMeta(Map<String, ConnectAddress> driverAddresses, String masterAddress) {
            this.driverAddresses = new HashMap<String, ConnectAddress>(driverAddresses);
            this.masterAddress = masterAddress;
            this.clientAddress = ProcessUtil.getHostAndIp();
        }

        public String getMasterAddress() {
            return this.masterAddress;
        }

        public void setMasterAddress(String masterAddress) {
            this.masterAddress = masterAddress;
        }

        public Map<String, ConnectAddress> getDriverAddresses() {
            return this.driverAddresses;
        }

        public void setDriverAddresses(Map<String, ConnectAddress> driverAddresses) {
            this.driverAddresses = driverAddresses;
        }

        public String getClientAddress() {
            return this.clientAddress;
        }

        public void setClientAddress(String clientAddress) {
            this.clientAddress = clientAddress;
        }

        public String toString() {
            return "ClusterMeta{clientAddress='" + this.clientAddress + '\'' + ", masterAddress='" + this.masterAddress + '\'' + ", driverAddresses=" + this.driverAddresses + '}';
        }
    }
}

