/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.client;

import com.google.protobuf.ByteString;
import java.util.concurrent.CompletableFuture;
import org.apache.geaflow.common.encoder.RpcMessageEncoder;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.pipeline.IPipelineResult;
import org.apache.geaflow.rpc.proto.Driver;

public class PipelineResult<R>
implements IPipelineResult<R> {
    private final CompletableFuture<Driver.PipelineRes> resultFuture;
    private Boolean success;
    private R result;

    public PipelineResult(CompletableFuture<Driver.PipelineRes> resultFuture) {
        this.resultFuture = resultFuture;
        this.success = null;
    }

    public boolean isSuccess() {
        if (this.success == null) {
            try {
                Driver.PipelineRes pipelineRes = this.resultFuture.get();
                this.result = RpcMessageEncoder.decode((ByteString)pipelineRes.getPayload());
            }
            catch (Exception e) {
                throw new GeaflowRuntimeException("get pipeline result error", (Throwable)e);
            }
            this.success = true;
            return true;
        }
        return this.success;
    }

    public R get() {
        if (this.isSuccess()) {
            return this.result;
        }
        throw new GeaflowRuntimeException("failed to get result");
    }
}

