/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.cluster.client;

import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.geaflow.cluster.client.IPipelineClient;
import org.apache.geaflow.cluster.client.utils.PipelineUtil;
import org.apache.geaflow.cluster.rpc.ConnectAddress;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.errorcode.RuntimeErrors;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineClientFactory.class);

    public static IPipelineClient createPipelineClient(Map<String, ConnectAddress> driverAddresses, Configuration config) {
        boolean isSync;
        ServiceLoader<IPipelineClient> clientLoader = ServiceLoader.load(IPipelineClient.class);
        Iterator<IPipelineClient> clientIterable = clientLoader.iterator();
        boolean bl = isSync = !PipelineUtil.isAsync(config);
        while (clientIterable.hasNext()) {
            IPipelineClient client = clientIterable.next();
            if (client.isSync() != isSync) continue;
            client.init(driverAddresses, config);
            return client;
        }
        LOGGER.error("NOT found IPipelineClient implementation");
        throw new GeaflowRuntimeException(RuntimeErrors.INST.spiNotFoundError(IPipelineClient.class.getSimpleName()));
    }
}

