/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.kafka;

import org.apache.fluss.kafka.KafkaRequest;
import org.apache.fluss.rpc.gateway.TabletServerGateway;
import org.apache.fluss.rpc.netty.server.RequestHandler;
import org.apache.fluss.rpc.protocol.RequestType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;

public class KafkaRequestHandler
implements RequestHandler<KafkaRequest> {
    private final TabletServerGateway gateway;

    public KafkaRequestHandler(TabletServerGateway gateway) {
        this.gateway = gateway;
    }

    public RequestType requestType() {
        return RequestType.KAFKA;
    }

    public void processRequest(KafkaRequest request) {
        switch (request.apiKey()) {
            case API_VERSIONS: {
                this.handleApiVersionsRequest(request);
                break;
            }
            case METADATA: {
                this.handleMetadataRequest(request);
                break;
            }
            case PRODUCE: {
                this.handleProducerRequest(request);
                break;
            }
            case FIND_COORDINATOR: {
                this.handleFindCoordinatorRequest(request);
                break;
            }
            case LIST_OFFSETS: {
                this.handleListOffsetRequest(request);
                break;
            }
            case OFFSET_FETCH: {
                this.handleOffsetFetchRequest(request);
                break;
            }
            case OFFSET_COMMIT: {
                this.handleOffsetCommitRequest(request);
                break;
            }
            case FETCH: {
                this.handleFetchRequest(request);
                break;
            }
            case JOIN_GROUP: {
                this.handleJoinGroupRequest(request);
                break;
            }
            case SYNC_GROUP: {
                this.handleSyncGroupRequest(request);
                break;
            }
            case HEARTBEAT: {
                this.handleHeartbeatRequest(request);
                break;
            }
            case LEAVE_GROUP: {
                this.handleLeaveGroupRequest(request);
                break;
            }
            case DESCRIBE_GROUPS: {
                this.handleDescribeGroupsRequest(request);
                break;
            }
            case LIST_GROUPS: {
                this.handleListGroupsRequest(request);
                break;
            }
            case DELETE_GROUPS: {
                this.handleDeleteGroupsRequest(request);
                break;
            }
            case SASL_HANDSHAKE: {
                this.handleSaslHandshakeRequest(request);
                break;
            }
            case SASL_AUTHENTICATE: {
                this.handleSaslAuthenticateRequest(request);
                break;
            }
            case CREATE_TOPICS: {
                this.handleCreateTopicsRequest(request);
                break;
            }
            case INIT_PRODUCER_ID: {
                this.handleInitProducerIdRequest(request);
                break;
            }
            case ADD_PARTITIONS_TO_TXN: {
                this.handleAddPartitionsToTxnRequest(request);
                break;
            }
            case ADD_OFFSETS_TO_TXN: {
                this.handleAddOffsetsToTxnRequest(request);
                break;
            }
            case TXN_OFFSET_COMMIT: {
                this.handleTxnOffsetCommitRequest(request);
                break;
            }
            case END_TXN: {
                this.handleEndTxnRequest(request);
                break;
            }
            case WRITE_TXN_MARKERS: {
                this.handleWriteTxnMarkersRequest(request);
                break;
            }
            case DESCRIBE_CONFIGS: {
                this.handleDescribeConfigsRequest(request);
                break;
            }
            case ALTER_CONFIGS: {
                this.handleAlterConfigsRequest(request);
                break;
            }
            case DELETE_TOPICS: {
                this.handleDeleteTopicsRequest(request);
                break;
            }
            case DELETE_RECORDS: {
                this.handleDeleteRecordsRequest(request);
                break;
            }
            case OFFSET_DELETE: {
                this.handleOffsetDeleteRequest(request);
                break;
            }
            case CREATE_PARTITIONS: {
                this.handleCreatePartitionsRequest(request);
                break;
            }
            case DESCRIBE_CLUSTER: {
                this.handleDescribeClusterRequest(request);
                break;
            }
            default: {
                this.handleUnsupportedRequest(request);
            }
        }
    }

    private void handleUnsupportedRequest(KafkaRequest request) {
        String message = String.format("Unsupported request with api key %s", request.apiKey());
        AbstractRequest abstractRequest = (AbstractRequest)request.request();
        AbstractResponse response = abstractRequest.getErrorResponse((Throwable)new UnsupportedOperationException(message));
        request.complete(response);
    }

    void handleApiVersionsRequest(KafkaRequest request) {
        short apiVersion = request.apiVersion();
        if (!ApiKeys.API_VERSIONS.isVersionSupported(apiVersion)) {
            request.fail((Throwable)Errors.UNSUPPORTED_VERSION.exception());
            return;
        }
        ApiVersionsResponseData data = new ApiVersionsResponseData();
        for (ApiKeys apiKey : ApiKeys.values()) {
            short v;
            if (apiKey.minRequiredInterBrokerMagic > 2) continue;
            ApiVersionsResponseData.ApiVersion apiVersionData = new ApiVersionsResponseData.ApiVersion().setApiKey(apiKey.id).setMinVersion(apiKey.oldestVersion()).setMaxVersion(apiKey.latestVersion());
            if (apiKey.equals((Object)ApiKeys.METADATA)) {
                v = apiKey.latestVersion() > 11 ? (short)11 : (short)apiKey.latestVersion();
                apiVersionData.setMaxVersion(v);
            } else if (apiKey.equals((Object)ApiKeys.FETCH)) {
                v = apiKey.latestVersion() > 12 ? (short)12 : (short)apiKey.latestVersion();
                apiVersionData.setMaxVersion(v);
            }
            data.apiKeys().add((ImplicitLinkedHashCollection.Element)apiVersionData);
        }
        request.complete((AbstractResponse)new ApiVersionsResponse(data));
    }

    void handleProducerRequest(KafkaRequest request) {
    }

    void handleMetadataRequest(KafkaRequest request) {
    }

    void handleFindCoordinatorRequest(KafkaRequest request) {
    }

    void handleListOffsetRequest(KafkaRequest request) {
    }

    void handleOffsetFetchRequest(KafkaRequest request) {
    }

    void handleOffsetCommitRequest(KafkaRequest request) {
    }

    void handleFetchRequest(KafkaRequest request) {
    }

    void handleJoinGroupRequest(KafkaRequest request) {
    }

    void handleSyncGroupRequest(KafkaRequest request) {
    }

    void handleHeartbeatRequest(KafkaRequest request) {
    }

    void handleLeaveGroupRequest(KafkaRequest request) {
    }

    void handleDescribeGroupsRequest(KafkaRequest request) {
    }

    void handleListGroupsRequest(KafkaRequest request) {
    }

    void handleDeleteGroupsRequest(KafkaRequest request) {
    }

    void handleSaslHandshakeRequest(KafkaRequest request) {
    }

    void handleSaslAuthenticateRequest(KafkaRequest request) {
    }

    void handleCreateTopicsRequest(KafkaRequest request) {
    }

    void handleInitProducerIdRequest(KafkaRequest request) {
    }

    void handleAddPartitionsToTxnRequest(KafkaRequest request) {
    }

    void handleAddOffsetsToTxnRequest(KafkaRequest request) {
    }

    void handleTxnOffsetCommitRequest(KafkaRequest request) {
    }

    void handleEndTxnRequest(KafkaRequest request) {
    }

    void handleWriteTxnMarkersRequest(KafkaRequest request) {
    }

    void handleDescribeConfigsRequest(KafkaRequest request) {
    }

    void handleAlterConfigsRequest(KafkaRequest request) {
    }

    void handleDeleteTopicsRequest(KafkaRequest request) {
    }

    void handleDeleteRecordsRequest(KafkaRequest request) {
    }

    void handleOffsetDeleteRequest(KafkaRequest request) {
    }

    void handleCreatePartitionsRequest(KafkaRequest request) {
    }

    void handleDescribeClusterRequest(KafkaRequest request) {
    }
}

