/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.kafka;

import java.time.Duration;
import java.util.List;
import org.apache.fluss.config.ConfigOptions;
import org.apache.fluss.config.Configuration;
import org.apache.fluss.kafka.KafkaChannelInitializer;
import org.apache.fluss.kafka.KafkaRequestHandler;
import org.apache.fluss.rpc.RpcGatewayService;
import org.apache.fluss.rpc.gateway.TabletServerGateway;
import org.apache.fluss.rpc.netty.server.RequestChannel;
import org.apache.fluss.rpc.netty.server.RequestHandler;
import org.apache.fluss.rpc.protocol.NetworkProtocolPlugin;
import org.apache.fluss.shaded.netty4.io.netty.channel.ChannelHandler;

public class KafkaProtocolPlugin
implements NetworkProtocolPlugin {
    private Configuration conf;

    public String name() {
        return KAFKA_PROTOCOL_NAME;
    }

    public void setup(Configuration conf) {
        this.conf = conf;
    }

    public List<String> listenerNames() {
        return (List)this.conf.get(ConfigOptions.KAFKA_LISTENER_NAMES);
    }

    public ChannelHandler createChannelHandler(RequestChannel[] requestChannels, String listenerName) {
        return new KafkaChannelInitializer(requestChannels, ((Duration)this.conf.get(ConfigOptions.KAFKA_CONNECTION_MAX_IDLE_TIME)).getSeconds());
    }

    public RequestHandler<?> createRequestHandler(RpcGatewayService service) {
        if (!(service instanceof TabletServerGateway)) {
            throw new IllegalArgumentException("Kafka protocol endpoints can only be enabled on TabletServers, but the service is " + service.getClass().getSimpleName());
        }
        TabletServerGateway gateway = (TabletServerGateway)service;
        return new KafkaRequestHandler(gateway);
    }
}

