/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.kafka;

import org.apache.fluss.kafka.KafkaCommandDecoder;
import org.apache.fluss.rpc.netty.NettyChannelInitializer;
import org.apache.fluss.rpc.netty.server.RequestChannel;
import org.apache.fluss.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.fluss.shaded.netty4.io.netty.channel.socket.SocketChannel;
import org.apache.fluss.shaded.netty4.io.netty.handler.codec.LengthFieldPrepender;
import org.apache.fluss.shaded.netty4.io.netty.handler.flow.FlowControlHandler;

public class KafkaChannelInitializer
extends NettyChannelInitializer {
    public static final int MAX_FRAME_LENGTH = 0x6400000;
    private final RequestChannel[] requestChannels;
    private final LengthFieldPrepender prepender = new LengthFieldPrepender(4);

    public KafkaChannelInitializer(RequestChannel[] requestChannels, long maxIdleTimeSeconds) {
        super(maxIdleTimeSeconds);
        this.requestChannels = requestChannels;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        super.initChannel(ch);
        this.addIdleStateHandler(ch);
        ch.pipeline().addLast(new ChannelHandler[]{this.prepender});
        this.addFrameDecoder(ch, 0x6400000, 4);
        ch.pipeline().addLast("flowController", (ChannelHandler)new FlowControlHandler());
        ch.pipeline().addLast(new ChannelHandler[]{new KafkaCommandDecoder(this.requestChannels)});
    }
}

