/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.spark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.RowColumn;
import org.apache.hadoop.io.Text;
import org.apache.spark.Partitioner;

public class AccumuloRangePartitioner
extends Partitioner {
    private static final long serialVersionUID = 1L;
    private List<Bytes> splits;

    public AccumuloRangePartitioner(Collection<Text> listSplits) {
        this.splits = new ArrayList<Bytes>(listSplits.size());
        for (Text text : listSplits) {
            this.splits.add(Bytes.of((byte[])text.getBytes(), (int)0, (int)text.getLength()));
        }
    }

    public int getPartition(Object o) {
        RowColumn rc = (RowColumn)o;
        int index = Collections.binarySearch(this.splits, rc.getRow());
        index = index < 0 ? (index + 1) * -1 : index;
        return index;
    }

    public int numPartitions() {
        return this.splits.size() + 1;
    }
}

