/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.mapreduce;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.data.Mutation;
import org.apache.fluo.accumulo.values.WriteValue;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumnValue;
import org.apache.fluo.core.util.ByteUtil;
import org.apache.fluo.core.util.Flutation;
import org.apache.hadoop.io.Text;

public class FluoMutationGenerator {
    private Mutation mutation;

    public FluoMutationGenerator(CharSequence row) {
        this.mutation = new Mutation(row);
    }

    public FluoMutationGenerator(Text row) {
        this.mutation = new Mutation(row);
    }

    public FluoMutationGenerator(Bytes row) {
        this.mutation = new Mutation(row.toArray());
    }

    public FluoMutationGenerator(byte[] row) {
        this.mutation = new Mutation(row);
    }

    public FluoMutationGenerator(RowColumnValue rcv) {
        this(rcv.getRow());
        this.put(rcv.getColumn(), rcv.getValue());
    }

    public FluoMutationGenerator put(Column col, CharSequence value) {
        return this.put(col, value.toString().getBytes(StandardCharsets.UTF_8));
    }

    public FluoMutationGenerator put(Column col, Text value) {
        return this.put(col, ByteUtil.toBytes((Text)value));
    }

    public FluoMutationGenerator put(Column col, Bytes value) {
        return this.put(col, value.toArray());
    }

    public FluoMutationGenerator put(Column col, byte[] value) {
        Flutation.put((Mutation)this.mutation, (Column)col, (long)-6917529027641081856L, (byte[])value);
        Flutation.put((Mutation)this.mutation, (Column)col, (long)0x4000000000000001L, (byte[])WriteValue.encode((long)0L, (boolean)false, (boolean)false));
        return this;
    }

    public Mutation build() {
        Mutation ret = this.mutation;
        this.mutation = null;
        return ret;
    }
}

