/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.mapreduce;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.data.Key;
import org.apache.fluo.accumulo.values.WriteValue;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumnValue;
import org.apache.fluo.core.util.ByteUtil;
import org.apache.fluo.mapreduce.FluoKeyValue;
import org.apache.hadoop.io.Text;

public class FluoKeyValueGenerator {
    private Column lastCol = null;
    private byte[] row;
    private byte[] fam;
    private byte[] qual;
    private byte[] vis;
    private byte[] val;
    private FluoKeyValue[] keyVals = new FluoKeyValue[2];

    public FluoKeyValueGenerator() {
        this.keyVals[0] = new FluoKeyValue();
        this.keyVals[1] = new FluoKeyValue();
    }

    public FluoKeyValueGenerator setRow(byte[] row) {
        this.row = row;
        return this;
    }

    public FluoKeyValueGenerator setRow(Text row) {
        this.row = ByteUtil.toByteArray((Text)row);
        return this;
    }

    public FluoKeyValueGenerator setRow(Bytes row) {
        this.row = row.toArray();
        return this;
    }

    public FluoKeyValueGenerator setRow(String row) {
        this.row = row.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public FluoKeyValueGenerator setColumn(Column col) {
        if (col == this.lastCol) {
            return this;
        }
        this.lastCol = col;
        this.fam = col.getFamily().toArray();
        this.qual = col.getQualifier().toArray();
        this.vis = col.getVisibility().toArray();
        return this;
    }

    public FluoKeyValueGenerator setValue(byte[] val) {
        this.val = val;
        return this;
    }

    public FluoKeyValueGenerator setValue(Text val) {
        this.val = ByteUtil.toByteArray((Text)val);
        return this;
    }

    public FluoKeyValueGenerator setValue(Bytes val) {
        this.val = val.toArray();
        return this;
    }

    public FluoKeyValueGenerator setValue(String val) {
        this.val = val.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public FluoKeyValueGenerator set(RowColumnValue rcv) {
        this.setRow(rcv.getRow());
        this.setColumn(rcv.getColumn());
        this.setValue(rcv.getValue());
        return this;
    }

    public FluoKeyValue[] getKeyValues() {
        FluoKeyValue kv = this.keyVals[0];
        kv.setKey(new Key(this.row, this.fam, this.qual, this.vis, 0x4000000000000001L));
        kv.getValue().set(WriteValue.encode((long)0L, (boolean)false, (boolean)false));
        kv = this.keyVals[1];
        kv.setKey(new Key(this.row, this.fam, this.qual, this.vis, -6917529027641081856L));
        kv.getValue().set(this.val);
        return this.keyVals;
    }
}

