/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.values;

import org.apache.fluo.accumulo.util.ByteArrayUtil;

public class WriteValue {
    private final boolean primary;
    private final boolean delete;
    private final long ts;

    public WriteValue(byte[] data) {
        this.primary = WriteValue.isPrimary(data);
        this.delete = WriteValue.isDelete(data);
        this.ts = WriteValue.getTimestamp(data);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public static boolean isPrimary(byte[] data) {
        return (data[0] & 1) == 1;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public static boolean isDelete(byte[] data) {
        return (data[0] & 2) == 2;
    }

    public long getTimestamp() {
        return this.ts;
    }

    public static long getTimestamp(byte[] data) {
        return ByteArrayUtil.decodeLong(data, 1);
    }

    public String toString() {
        return this.ts + (this.delete ? " DELETE" : "") + " " + (this.primary ? "PRIMARY" : "");
    }

    public static byte[] encode(long ts, boolean primary, boolean delete) {
        byte[] ba = new byte[9];
        ba[0] = (byte)((primary ? 1 : 0) | (delete ? 2 : 0));
        ByteArrayUtil.encode(ba, 1, ts);
        return ba;
    }
}

