/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.values;

import org.apache.fluo.accumulo.util.ByteArrayUtil;

public class DelLockValue {
    private final boolean primary;
    private final boolean rollback;
    private final long txDoneTs;

    public DelLockValue(byte[] data) {
        this.primary = DelLockValue.isPrimary(data);
        this.rollback = DelLockValue.isRollback(data);
        this.txDoneTs = DelLockValue.getTxDoneTimestamp(data);
    }

    public long getCommitTimestamp() {
        return this.txDoneTs;
    }

    public static long getTxDoneTimestamp(byte[] data) {
        return ByteArrayUtil.decodeLong(data, 1);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public static boolean isPrimary(byte[] data) {
        return (data[0] & 1) == 1;
    }

    public boolean isRollback() {
        return this.rollback;
    }

    public static boolean isRollback(byte[] data) {
        return (data[0] & 2) == 2;
    }

    public static byte[] encodeCommit(long ts, boolean primary) {
        byte[] ba = new byte[9];
        ba[0] = (byte)(primary ? 1 : 0);
        ByteArrayUtil.encode(ba, 1, ts);
        return ba;
    }

    public static byte[] encodeRollback(boolean primary, boolean rollback) {
        byte[] ba = new byte[9];
        ba[0] = (byte)((primary ? 1 : 0) | (rollback ? 2 : 0));
        ByteArrayUtil.encode(ba, 1, 0L);
        return ba;
    }

    public static byte[] encodeRollback(long ts, boolean primary, boolean rollback) {
        byte[] ba = new byte[9];
        ba[0] = (byte)((primary ? 1 : 0) | (rollback ? 2 : 0));
        ByteArrayUtil.encode(ba, 1, ts);
        return ba;
    }

    public String toString() {
        return (this.rollback ? "ABORT " : "COMMIT ") + (this.primary ? "PRIMARY " : "") + this.txDoneTs;
    }
}

