/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.util;

import java.util.List;
import org.apache.accumulo.core.data.Key;
import org.apache.fluo.accumulo.iterators.NotificationIterator;
import org.apache.fluo.accumulo.util.ByteArrayUtil;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;

public class NotificationUtil {
    private static final long DEL_MASK = 1L;

    public static boolean isDelete(Key k) {
        return NotificationUtil.isDelete(k.getTimestamp());
    }

    public static boolean isDelete(long ts) {
        return (ts & 1L) == 1L;
    }

    public static boolean isNtfy(Key key) {
        return key.getColumnFamilyData().equals((Object)NotificationIterator.NTFY_CF);
    }

    public static long encodeTs(long ts, boolean isDelete) {
        return ts << 1 | (long)(isDelete ? 1 : 0);
    }

    public static long decodeTs(Key k) {
        return NotificationUtil.decodeTs(k.getTimestamp());
    }

    public static long decodeTs(long ts) {
        return ts >> 1;
    }

    public static byte[] encodeCol(Column c) {
        return ByteArrayUtil.concat(c.getFamily(), c.getQualifier());
    }

    public static Column decodeCol(Key k) {
        return NotificationUtil.decodeCol(k.getColumnQualifierData().toArray());
    }

    public static Column decodeCol(byte[] cq) {
        List<Bytes> ca = ByteArrayUtil.split(cq);
        Column col = new Column(ca.get(0), ca.get(1));
        return col;
    }
}

