/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.iterators;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.SortedMapIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.iterators.system.DeletingIterator;
import org.apache.accumulo.core.iterators.system.SourceSwitchingIterator;
import org.apache.accumulo.core.iterators.system.SynchronizedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampSkippingIterator
implements SortedKeyValueIterator<Key, Value> {
    private final SortedKeyValueIterator<Key, Value> source;
    private Range range;
    private Collection<ByteSequence> fams;
    private boolean inclusive;
    private boolean hasSeeked = false;
    private boolean removedDeletingIterator = false;
    private int removalFailures = 0;
    private static final Logger log = LoggerFactory.getLogger(TimestampSkippingIterator.class);

    public TimestampSkippingIterator(SortedKeyValueIterator<Key, Value> source) {
        this.source = source;
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean hasTop() {
        return this.source.hasTop();
    }

    public void next() throws IOException {
        this.source.next();
    }

    public void skipToTimestamp(Key curCol, long timestamp) throws IOException {
        this.source.next();
        int count = 0;
        while (this.source.hasTop() && curCol.equals((Key)this.source.getTopKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS) && timestamp < ((Key)this.source.getTopKey()).getTimestamp()) {
            if (count == 10 && this.shouldSeek()) {
                Key seekKey = new Key(curCol);
                seekKey.setTimestamp(timestamp);
                Range newRange = new Range(seekKey, true, this.range.getEndKey(), this.range.isEndKeyInclusive());
                this.seek(newRange);
                break;
            }
            this.source.next();
            ++count;
        }
    }

    public void skipToPrefix(Key curCol, long prefix) throws IOException {
        long timestamp = prefix | 0x1FFFFFFFFFFFFFFFL;
        this.skipToTimestamp(curCol, timestamp);
    }

    public void skipColumn(Key curCol) throws IOException {
        this.source.next();
        int count = 0;
        while (this.source.hasTop() && curCol.equals((Key)this.source.getTopKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
            if (count == 10) {
                Key seekKey = curCol.followingKey(PartialKey.ROW_COLFAM_COLQUAL_COLVIS);
                Range newRange = this.range.afterEndKey(seekKey) ? new Range(this.range.getEndKey(), true, this.range.getEndKey(), false) : new Range(seekKey, true, this.range.getEndKey(), this.range.isEndKeyInclusive());
                this.seek(newRange);
                break;
            }
            this.source.next();
            ++count;
        }
    }

    private static SortedKeyValueIterator<Key, Value> getParent(SortedKeyValueIterator<Key, Value> iter) {
        try {
            if (iter instanceof WrappingIterator) {
                Field field = WrappingIterator.class.getDeclaredField("source");
                field.setAccessible(true);
                return (SortedKeyValueIterator)field.get(iter);
            }
            if (iter instanceof SourceSwitchingIterator) {
                Field field = SourceSwitchingIterator.class.getDeclaredField("iter");
                field.setAccessible(true);
                return (SortedKeyValueIterator)field.get(iter);
            }
            if (iter instanceof SynchronizedIterator) {
                Field field = SynchronizedIterator.class.getDeclaredField("source");
                field.setAccessible(true);
                return (SortedKeyValueIterator)field.get(iter);
            }
            if (iter instanceof SortedMapIterator) {
                return null;
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static boolean setParent(SortedKeyValueIterator<Key, Value> iter, SortedKeyValueIterator<Key, Value> newParent) {
        try {
            if (iter instanceof WrappingIterator) {
                Field field = WrappingIterator.class.getDeclaredField("source");
                field.setAccessible(true);
                field.set(iter, newParent);
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static boolean removeDeletingIterator(SortedKeyValueIterator<Key, Value> source) {
        SortedKeyValueIterator<Key, Value> delParent;
        SortedKeyValueIterator<Key, Value> prev = source;
        SortedKeyValueIterator<Key, Value> parent = TimestampSkippingIterator.getParent(source);
        while (parent != null && !(parent instanceof DeletingIterator)) {
            prev = parent;
            parent = TimestampSkippingIterator.getParent(parent);
        }
        if (parent != null && parent instanceof DeletingIterator && (delParent = TimestampSkippingIterator.getParent(parent)) != null) {
            return TimestampSkippingIterator.setParent(prev, delParent);
        }
        return false;
    }

    @VisibleForTesting
    public final boolean shouldSeek() {
        return !this.hasSeeked || this.removedDeletingIterator || this.removalFailures < 3;
    }

    private void seek(Range range) throws IOException {
        if (this.hasSeeked) {
            this.removedDeletingIterator |= TimestampSkippingIterator.removeDeletingIterator(this.source);
            if (!this.removedDeletingIterator) {
                ++this.removalFailures;
            }
        }
        this.source.seek(range, this.fams, this.inclusive);
        this.hasSeeked = true;
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.range = range;
        this.fams = columnFamilies;
        this.inclusive = inclusive;
        this.seek(range);
    }

    public Key getTopKey() {
        return (Key)this.source.getTopKey();
    }

    public Value getTopValue() {
        return (Value)this.source.getTopValue();
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }
}

