/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.fluo.accumulo.iterators.SnapshotIterator;
import org.apache.fluo.accumulo.values.WriteValue;

public class RollbackCheckIterator
implements SortedKeyValueIterator<Key, Value> {
    private static final String TIMESTAMP_OPT = "timestampOpt";
    private SortedKeyValueIterator<Key, Value> source;
    private long lockTime;
    boolean hasTop = false;
    boolean checkAck = false;

    public static void setLocktime(IteratorSetting cfg, long time) {
        if (time < 0L || (0xE000000000000000L & time) != 0L) {
            throw new IllegalArgumentException();
        }
        cfg.addOption(TIMESTAMP_OPT, time + "");
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.source = source;
        this.lockTime = Long.parseLong(options.get(TIMESTAMP_OPT));
    }

    public boolean hasTop() {
        return this.hasTop && this.source.hasTop();
    }

    public void next() throws IOException {
        this.hasTop = false;
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        range = IteratorUtil.maximizeStartKeyTimeStamp((Range)range);
        if (columnFamilies.isEmpty() && !inclusive) {
            this.source.seek(range, SnapshotIterator.NOTIFY_CF_SET, false);
        } else {
            this.source.seek(range, columnFamilies, inclusive);
        }
        Key curCol = new Key();
        if (this.source.hasTop()) {
            curCol.set((Key)this.source.getTopKey());
            if (!curCol.equals(range.getStartKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
                return;
            }
        }
        long invalidationTime = -1L;
        this.hasTop = false;
        while (this.source.hasTop() && curCol.equals((Key)this.source.getTopKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
            long colType = ((Key)this.source.getTopKey()).getTimestamp() & 0xE000000000000000L;
            long ts = ((Key)this.source.getTopKey()).getTimestamp() & 0x1FFFFFFFFFFFFFFFL;
            if (colType != 0x6000000000000000L) {
                if (colType == 0x4000000000000000L) {
                    long timePtr = WriteValue.getTimestamp(((Value)this.source.getTopValue()).get());
                    if (timePtr > invalidationTime) {
                        invalidationTime = timePtr;
                    }
                    if (this.lockTime == timePtr) {
                        this.hasTop = true;
                        return;
                    }
                } else if (colType == 0x2000000000000000L) {
                    if (ts > invalidationTime) {
                        invalidationTime = ts;
                    }
                    if (ts == this.lockTime) {
                        this.hasTop = true;
                        return;
                    }
                } else if (colType == -2305843009213693952L) {
                    if (ts > invalidationTime) {
                        this.hasTop = true;
                        return;
                    }
                } else {
                    if (colType == -6917529027641081856L) {
                        return;
                    }
                    if (colType != -4611686018427387904L) {
                        throw new IllegalArgumentException();
                    }
                }
            }
            this.source.next();
        }
    }

    public Key getTopKey() {
        return (Key)this.source.getTopKey();
    }

    public Value getTopValue() {
        return (Value)this.source.getTopValue();
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return null;
    }
}

