/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SkippingIterator;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.fluo.accumulo.iterators.PushbackIterator;
import org.apache.fluo.accumulo.util.ColumnConstants;
import org.apache.fluo.accumulo.util.NotificationUtil;

public class NotificationIterator
extends SkippingIterator {
    public static final ByteSequence NTFY_CF = new ArrayByteSequence(ColumnConstants.NOTIFY_CF.toArray());
    private boolean scanOrFullMajc;
    private boolean lastKeySet = false;
    private Key lastKey = new Key();
    private Range seekRange;
    private Collection<ByteSequence> colFams;
    private boolean inclusive;

    private void skipRowCol(PushbackIterator source, Key key) throws IOException {
        int count = 0;
        while (source.hasTop() && source.getTopKey().equals(key, PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
            Key nextKey;
            if (count == 10 && !this.seekRange.afterEndKey(nextKey = key.followingKey(PartialKey.ROW_COLFAM_COLQUAL_COLVIS))) {
                this.seekRange = new Range(nextKey, true, this.seekRange.getEndKey(), this.seekRange.isEndKeyInclusive());
                source.seek(this.seekRange, this.colFams, this.inclusive);
                break;
            }
            source.next();
            ++count;
        }
    }

    protected void consume() throws IOException {
        PushbackIterator source = (PushbackIterator)this.getSource();
        if (this.lastKeySet) {
            this.skipRowCol(source, this.lastKey);
        }
        this.consumeDeletes(source);
        if (source.hasTop() && NotificationUtil.isNtfy(source.getTopKey()) && !NotificationUtil.isDelete(source.getTopKey())) {
            this.lastKey.set(source.getTopKey());
            this.lastKeySet = true;
        } else {
            this.lastKeySet = false;
        }
    }

    private void consumeDeletes(PushbackIterator source) throws IOException {
        while (source.hasTop() && NotificationUtil.isNtfy(source.getTopKey()) && NotificationUtil.isDelete(source.getTopKey())) {
            Key keyCopy = new Key(source.getTopKey());
            if (this.scanOrFullMajc) {
                source.next();
                this.skipRowCol(source, keyCopy);
                continue;
            }
            Value valCopy = new Value(source.getTopValue());
            boolean lastKeyWasDelete = true;
            boolean isOrderly = true;
            source.next();
            while (source.hasTop() && source.getTopKey().equals(keyCopy, PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
                isOrderly &= NotificationUtil.isDelete(source.getTopKey()) ^ lastKeyWasDelete;
                lastKeyWasDelete = NotificationUtil.isDelete(source.getTopKey());
                source.next();
            }
            if (isOrderly && !lastKeyWasDelete) continue;
            source.pushback(keyCopy, valCopy);
            break;
        }
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.lastKeySet = false;
        this.seekRange = IteratorUtil.maximizeStartKeyTimeStamp((Range)range);
        this.colFams = new HashSet<ByteSequence>(columnFamilies);
        this.inclusive = inclusive;
        super.seek(this.seekRange, columnFamilies, inclusive);
        while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
            this.next();
        }
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.scanOrFullMajc = env.getIteratorScope() == IteratorUtil.IteratorScope.scan || env.getIteratorScope() == IteratorUtil.IteratorScope.majc && env.isFullMajorCompaction();
        super.init((SortedKeyValueIterator)new PushbackIterator(source), options, env);
    }
}

