/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.iterators;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.fluo.accumulo.util.ColumnConstants;
import org.apache.fluo.accumulo.util.ZookeeperUtil;
import org.apache.fluo.accumulo.values.DelLockValue;
import org.apache.fluo.accumulo.values.WriteValue;

public class GarbageCollectionIterator
implements SortedKeyValueIterator<Key, Value> {
    @VisibleForTesting
    static final String GC_TIMESTAMP_OPT = "timestamp.gc";
    private static final String ZOOKEEPER_CONNECT_OPT = "zookeeper.connect";
    private static final ByteSequence NOTIFY_CF_BS = new ArrayByteSequence(ColumnConstants.NOTIFY_CF.toArray());
    private Long gcTimestamp;
    private SortedKeyValueIterator<Key, Value> source;
    private ArrayList<KeyValue> keys = new ArrayList();
    private ArrayList<KeyValue> keysFiltered = new ArrayList();
    private HashSet<Long> completeTxs = new HashSet();
    private HashSet<Long> rolledback = new HashSet();
    private Key curCol = new Key();
    private long truncationTime;
    private int position = 0;
    boolean isFullMajc;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        if (env.getIteratorScope() == IteratorUtil.IteratorScope.scan) {
            throw new IllegalArgumentException();
        }
        this.source = source;
        this.isFullMajc = env.getIteratorScope() == IteratorUtil.IteratorScope.majc && env.isFullMajorCompaction();
        String oats = options.get(GC_TIMESTAMP_OPT);
        if (oats != null) {
            this.gcTimestamp = Long.valueOf(oats);
        } else {
            String zookeepers = options.get(ZOOKEEPER_CONNECT_OPT);
            if (zookeepers == null) {
                throw new IllegalArgumentException("A configuration item for GC iterator was not set");
            }
            this.gcTimestamp = ZookeeperUtil.getGcTimestamp(zookeepers);
        }
    }

    public boolean hasTop() {
        return this.position < this.keysFiltered.size() || this.source.hasTop();
    }

    private void findTop() throws IOException {
        while (this.source.hasTop()) {
            this.readColMetadata();
            if (this.keysFiltered.size() == 0 && this.consumeData()) continue;
            break;
        }
    }

    public void next() throws IOException {
        if (this.position < this.keysFiltered.size() - 1) {
            ++this.position;
            return;
        }
        if (this.position == this.keysFiltered.size() - 1) {
            ++this.position;
        } else {
            this.source.next();
        }
        if (this.consumeData()) {
            this.findTop();
        }
    }

    private boolean consumeData() throws IOException {
        while (this.source.hasTop() && this.curCol.equals((Key)this.source.getTopKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
            long colType = ((Key)this.source.getTopKey()).getTimestamp() & 0xE000000000000000L;
            long ts = ((Key)this.source.getTopKey()).getTimestamp() & 0x1FFFFFFFFFFFFFFFL;
            if (colType == -6917529027641081856L) {
                if (ts >= this.truncationTime && !this.rolledback.contains(ts)) {
                    return false;
                }
            } else {
                return false;
            }
            this.source.next();
        }
        return true;
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.source.seek(range, columnFamilies, inclusive);
        this.findTop();
    }

    private void readColMetadata() throws IOException {
        long invalidationTime = -1L;
        boolean oldestSeen = false;
        boolean sawAck = false;
        long firstWrite = -1L;
        this.truncationTime = -1L;
        this.position = 0;
        this.keys.clear();
        this.keysFiltered.clear();
        this.completeTxs.clear();
        this.rolledback.clear();
        this.curCol.set((Key)this.source.getTopKey());
        if (((Key)this.source.getTopKey()).getColumnFamilyData().equals((Object)NOTIFY_CF_BS)) {
            return;
        }
        while (this.source.hasTop() && this.curCol.equals((Key)this.source.getTopKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
            boolean keep;
            long colType = ((Key)this.source.getTopKey()).getTimestamp() & 0xE000000000000000L;
            long ts = ((Key)this.source.getTopKey()).getTimestamp() & 0x1FFFFFFFFFFFFFFFL;
            if (colType == 0x6000000000000000L) {
                this.keys.add(new KeyValue((Key)this.source.getTopKey(), (Value)this.source.getTopValue()));
                this.completeTxs.add(ts);
            } else if (colType == 0x4000000000000000L) {
                keep = false;
                boolean complete = this.completeTxs.contains(ts);
                byte[] val = ((Value)this.source.getTopValue()).get();
                long timePtr = WriteValue.getTimestamp(val);
                if (WriteValue.isPrimary(val) && !complete) {
                    keep = true;
                }
                if (!oldestSeen) {
                    if (firstWrite == -1L) {
                        firstWrite = ts;
                    }
                    if (ts < this.gcTimestamp) {
                        oldestSeen = true;
                        this.truncationTime = timePtr;
                        if (!WriteValue.isDelete(val) || !this.isFullMajc) {
                            keep = true;
                        }
                    } else {
                        keep = true;
                    }
                }
                if (timePtr > invalidationTime) {
                    invalidationTime = timePtr;
                }
                if (keep) {
                    this.keys.add(new KeyValue((Key)this.source.getTopKey(), val));
                } else if (complete) {
                    this.completeTxs.remove(ts);
                }
            } else if (colType == 0x2000000000000000L) {
                keep = false;
                long txDoneTs = DelLockValue.getTxDoneTimestamp(((Value)this.source.getTopValue()).get());
                boolean complete = this.completeTxs.contains(txDoneTs);
                byte[] val = ((Value)this.source.getTopValue()).get();
                if (!complete && DelLockValue.isPrimary(val)) {
                    keep = true;
                }
                if (DelLockValue.isRollback(val)) {
                    this.rolledback.add(ts);
                    keep |= !this.isFullMajc;
                }
                if (ts > invalidationTime) {
                    invalidationTime = ts;
                }
                if (keep) {
                    this.keys.add(new KeyValue((Key)this.source.getTopKey(), (Value)this.source.getTopValue()));
                } else if (complete) {
                    this.completeTxs.remove(txDoneTs);
                }
            } else if (colType == -2305843009213693952L) {
                if (ts > invalidationTime) {
                    this.keys.add(new KeyValue((Key)this.source.getTopKey(), (Value)this.source.getTopValue()));
                }
            } else {
                if (colType == -6917529027641081856L) break;
                if (colType == -4611686018427387904L) {
                    if (!sawAck) {
                        if (ts >= firstWrite) {
                            this.keys.add(new KeyValue((Key)this.source.getTopKey(), (Value)this.source.getTopValue()));
                        }
                        sawAck = true;
                    }
                } else {
                    throw new IllegalArgumentException(" unknown colType " + String.format("%x", colType));
                }
            }
            this.source.next();
        }
        for (KeyValue kv : this.keys) {
            long colType = ((Key)kv.getKey()).getTimestamp() & 0xE000000000000000L;
            if (colType == 0x6000000000000000L) {
                if (!this.completeTxs.contains(((Key)kv.getKey()).getTimestamp() & 0x1FFFFFFFFFFFFFFFL)) continue;
                this.keysFiltered.add(kv);
                continue;
            }
            this.keysFiltered.add(kv);
        }
    }

    public Key getTopKey() {
        if (this.position < this.keysFiltered.size()) {
            return (Key)this.keysFiltered.get(this.position).getKey();
        }
        return (Key)this.source.getTopKey();
    }

    public Value getTopValue() {
        if (this.position < this.keysFiltered.size()) {
            return (Value)this.keysFiltered.get(this.position).getValue();
        }
        return (Value)this.source.getTopValue();
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public static void setZookeepers(IteratorSetting gcIter, String zookeepers) {
        gcIter.addOption(ZOOKEEPER_CONNECT_OPT, zookeepers);
    }

    private static class KeyValue
    extends AbstractMap.SimpleImmutableEntry<Key, Value> {
        private static final long serialVersionUID = 1L;

        public KeyValue(Key key, Value value) {
            super(new Key(key), new Value(value));
        }

        public KeyValue(Key key, byte[] value) {
            super(new Key(key), new Value(value));
        }
    }
}

