/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.clients.log4jappender;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.FlumeException;
import org.apache.flume.api.RpcClientFactory;
import org.apache.flume.clients.log4jappender.Log4jAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class LoadBalancingLog4jAppender
extends Log4jAppender {
    private String hosts;
    private String selector;
    private String maxBackoff;
    private boolean configured = false;

    public void setHosts(String hostNames) {
        this.hosts = hostNames;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void setMaxBackoff(String maxBackoff) {
        this.maxBackoff = maxBackoff;
    }

    @Override
    public synchronized void append(LoggingEvent event) {
        if (!this.configured) {
            String errorMsg = "Flume Log4jAppender not configured correctly! Cannot send events to Flume.";
            LogLog.error((String)errorMsg);
            if (this.getUnsafeMode()) {
                return;
            }
            throw new FlumeException(errorMsg);
        }
        super.append(event);
    }

    @Override
    public void activateOptions() throws FlumeException {
        try {
            Properties properties = this.getProperties(this.hosts, this.selector, this.maxBackoff, this.getTimeout());
            this.rpcClient = RpcClientFactory.getInstance((Properties)properties);
            if (this.layout != null) {
                this.layout.activateOptions();
            }
            this.configured = true;
        }
        catch (Exception e) {
            String errormsg = "RPC client creation failed! " + e.getMessage();
            LogLog.error((String)errormsg);
            if (this.getUnsafeMode()) {
                return;
            }
            throw new FlumeException((Throwable)e);
        }
    }

    private Properties getProperties(String hosts, String selector, String maxBackoff, long timeout) throws FlumeException {
        if (StringUtils.isEmpty((String)hosts)) {
            throw new FlumeException("hosts must not be null");
        }
        Properties props = new Properties();
        String[] hostsAndPorts = hosts.split("\\s+");
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < hostsAndPorts.length; ++i) {
            String hostAndPort = hostsAndPorts[i];
            String name = "h" + i;
            props.setProperty("hosts." + name, hostAndPort);
            names.append(name).append(" ");
        }
        props.put("hosts", names.toString());
        props.put("client.type", RpcClientFactory.ClientType.DEFAULT_LOADBALANCE.toString());
        if (!StringUtils.isEmpty((String)selector)) {
            props.put("host-selector", selector);
        }
        if (!StringUtils.isEmpty((String)maxBackoff)) {
            long millis = Long.parseLong(maxBackoff.trim());
            if (millis <= 0L) {
                throw new FlumeException("Misconfigured max backoff, value must be greater than 0");
            }
            props.put("backoff", String.valueOf(true));
            props.put("maxBackoff", maxBackoff);
        }
        props.setProperty("connect-timeout", String.valueOf(timeout));
        props.setProperty("request-timeout", String.valueOf(timeout));
        return props;
    }
}

