/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.solr;

import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.base.Configs;
import com.cloudera.cdk.morphline.solr.DocumentLoader;
import com.cloudera.cdk.morphline.solr.SafeConcurrentUpdateSolrServer;
import com.cloudera.cdk.morphline.solr.SolrMorphlineContext;
import com.cloudera.cdk.morphline.solr.SolrServerDocumentLoader;
import com.cloudera.cdk.morphline.solr.ZooKeeperDownloader;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.util.SystemIdResolver;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SolrLocator {
    private Config config;
    private MorphlineContext context;
    private String collectionName;
    private String zkHost;
    private String solrUrl;
    private String solrHomeDir;
    private int batchSize = 100;
    private static final String SOLR_HOME_PROPERTY_NAME = "solr.solr.home";
    private static final Logger LOG = LoggerFactory.getLogger(SolrLocator.class);

    protected SolrLocator(MorphlineContext context) {
        Preconditions.checkNotNull((Object)context);
        this.context = context;
    }

    public SolrLocator(Config config, MorphlineContext context) {
        this(context);
        this.config = config;
        Configs configs = new Configs();
        this.collectionName = configs.getString(config, "collection", null);
        this.zkHost = configs.getString(config, "zkHost", null);
        this.solrHomeDir = configs.getString(config, "solrHomeDir", null);
        this.solrUrl = configs.getString(config, "solrUrl", null);
        this.batchSize = configs.getInt(config, "batchSize", this.batchSize);
        LOG.trace("Constructed solrLocator: {}", (Object)this);
        configs.validateArguments(config);
    }

    public DocumentLoader getLoader() {
        int solrServerNumThreads;
        DocumentLoader loader;
        if (this.context instanceof SolrMorphlineContext && (loader = ((SolrMorphlineContext)this.context).getDocumentLoader()) != null) {
            return loader;
        }
        if (this.zkHost != null && this.zkHost.length() > 0) {
            if (this.collectionName == null || this.collectionName.length() == 0) {
                throw new MorphlineCompilationException("Parameter 'zkHost' requires that you also pass parameter 'collection'", this.config);
            }
            try {
                CloudSolrServer cloudSolrServer = new CloudSolrServer(this.zkHost);
                cloudSolrServer.setDefaultCollection(this.collectionName);
                cloudSolrServer.connect();
                return new SolrServerDocumentLoader((SolrServer)cloudSolrServer, this.batchSize);
            }
            catch (MalformedURLException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
        }
        if (this.solrUrl == null || this.solrUrl.length() == 0) {
            throw new MorphlineCompilationException("Missing parameter 'solrUrl'", this.config);
        }
        int solrServerQueueLength = solrServerNumThreads = 2;
        SafeConcurrentUpdateSolrServer server = new SafeConcurrentUpdateSolrServer(this.solrUrl, solrServerQueueLength, solrServerNumThreads);
        return new SolrServerDocumentLoader((SolrServer)server, this.batchSize);
    }

    public IndexSchema getIndexSchema() {
        IndexSchema schema;
        if (this.context instanceof SolrMorphlineContext && (schema = ((SolrMorphlineContext)this.context).getIndexSchema()) != null) {
            this.validateSchema(schema);
            return schema;
        }
        String oldSolrHomeDir = null;
        String mySolrHomeDir = this.solrHomeDir;
        if (this.solrHomeDir == null || this.solrHomeDir.length() == 0) {
            if (this.zkHost == null || this.zkHost.length() == 0) {
                throw new MorphlineCompilationException("Downloading a Solr schema requires either parameter 'solrHomeDir' or parameters 'zkHost' and 'collection'", this.config);
            }
            if (this.collectionName == null || this.collectionName.length() == 0) {
                throw new MorphlineCompilationException("Parameter 'zkHost' requires that you also pass parameter 'collection'", this.config);
            }
            ZooKeeperDownloader zki = new ZooKeeperDownloader();
            SolrZkClient zkClient = zki.getZkClient(this.zkHost);
            try {
                String configName = zki.readConfigName(zkClient, this.collectionName);
                File downloadedSolrHomeDir = zki.downloadConfigDir(zkClient, configName);
                mySolrHomeDir = downloadedSolrHomeDir.getAbsolutePath();
            }
            catch (KeeperException e) {
                throw new MorphlineCompilationException("Cannot download schema.xml from ZooKeeper", this.config, (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new MorphlineCompilationException("Cannot download schema.xml from ZooKeeper", this.config, (Throwable)e);
            }
            catch (IOException e) {
                throw new MorphlineCompilationException("Cannot download schema.xml from ZooKeeper", this.config, (Throwable)e);
            }
            finally {
                zkClient.close();
            }
        }
        oldSolrHomeDir = System.setProperty(SOLR_HOME_PROPERTY_NAME, mySolrHomeDir);
        try {
            SolrConfig solrConfig = new SolrConfig();
            SolrResourceLoader loader = solrConfig.getResourceLoader();
            InputSource is = new InputSource(loader.openSchema("schema.xml"));
            is.setSystemId(SystemIdResolver.createSystemIdFromResourceName((String)"schema.xml"));
            IndexSchema schema2 = new IndexSchema(solrConfig, "schema.xml", is);
            this.validateSchema(schema2);
            IndexSchema indexSchema = schema2;
            return indexSchema;
        }
        catch (ParserConfigurationException e) {
            throw new MorphlineRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new MorphlineRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MorphlineRuntimeException((Throwable)e);
        }
        finally {
            if (this.solrHomeDir != null) {
                if (oldSolrHomeDir == null) {
                    System.clearProperty(SOLR_HOME_PROPERTY_NAME);
                } else {
                    System.setProperty(SOLR_HOME_PROPERTY_NAME, oldSolrHomeDir);
                }
            }
        }
    }

    private void validateSchema(IndexSchema schema) {
        if (schema.getUniqueKeyField() == null) {
            throw new MorphlineCompilationException("Solr schema.xml is missing unique key field", this.config);
        }
        if (!schema.getUniqueKeyField().isRequired()) {
            throw new MorphlineCompilationException("Solr schema.xml must contain a required unique key field", this.config);
        }
    }

    public String toString() {
        return this.toConfig(null).root().render(ConfigRenderOptions.concise());
    }

    public Config toConfig(String key) {
        String json = "";
        if (key != null) {
            json = this.toJson(key) + " : ";
        }
        json = json + "{ collection : " + this.toJson(this.collectionName) + ", " + " zkHost : " + this.toJson(this.zkHost) + ", " + " solrUrl : " + this.toJson(this.solrUrl) + ", " + " solrHomeDir : " + this.toJson(this.solrHomeDir) + ", " + " batchSize : " + this.toJson(this.batchSize) + " " + "}";
        return ConfigFactory.parseString((String)json);
    }

    private String toJson(Object key) {
        String str = key == null ? "" : key.toString();
        str = ConfigUtil.quoteString((String)str);
        return str;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getZkHost() {
        return this.zkHost;
    }

    public void setZkHost(String zkHost) {
        this.zkHost = zkHost;
    }

    public String getSolrHomeDir() {
        return this.solrHomeDir;
    }

    public void setSolrHomeDir(String solrHomeDir) {
        this.solrHomeDir = solrHomeDir;
    }

    public String getServerUrl() {
        return this.solrUrl;
    }

    public void setServerUrl(String solrUrl) {
        this.solrUrl = solrUrl;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

