/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.solr;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.solr.SolrLocator;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.solr.schema.IndexSchema;

public final class SanitizeUnknownSolrFieldsBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("sanitizeUnknownSolrFields");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new SanitizeUnknownSolrFields(config, parent, child, context);
    }

    private static final class SanitizeUnknownSolrFields
    extends AbstractCommand {
        private final IndexSchema schema;
        private final String renameToPrefix;

        public SanitizeUnknownSolrFields(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            Config solrLocatorConfig = this.getConfigs().getConfig(config, "solrLocator");
            SolrLocator locator = new SolrLocator(solrLocatorConfig, context);
            this.LOG.debug("solrLocator: {}", (Object)locator);
            this.schema = locator.getIndexSchema();
            Preconditions.checkNotNull((Object)this.schema);
            this.LOG.trace("Solr schema: \n{}", (Object)Joiner.on((String)"\n").join(new TreeMap(this.schema.getFields()).values()));
            String str = this.getConfigs().getString(config, "renameToPrefix", "").trim();
            this.renameToPrefix = str.length() > 0 ? str : null;
            this.validateArguments();
        }

        protected boolean doProcess(Record record) {
            ArrayList keys = new ArrayList(record.getFields().keySet());
            for (String key : keys) {
                if (this.schema.getFieldOrNull(key) != null) continue;
                this.LOG.debug("Sanitizing unknown Solr field: {}", (Object)key);
                if (this.renameToPrefix != null) {
                    List values = record.getFields().get((Object)key);
                    record.getFields().putAll((Object)(this.renameToPrefix + key), (Iterable)values);
                }
                record.removeAll(key);
            }
            return super.doProcess(record);
        }
    }
}

