/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.tika.decompress;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.Record;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;

final class EmbeddedExtractor {
    EmbeddedExtractor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseEmbedded(InputStream stream, Record record, String name, Command child) {
        TemporaryResources tmp = new TemporaryResources();
        try {
            Object container;
            TikaInputStream newStream = TikaInputStream.get((InputStream)new CloseShieldInputStream(stream), (TemporaryResources)tmp);
            if (stream instanceof TikaInputStream && (container = ((TikaInputStream)stream).getOpenContainer()) != null) {
                newStream.setOpenContainer(container);
            }
            record = record.copy();
            record.replaceValues("_attachment_body", (Object)newStream);
            record.removeAll("_attachment_mimetype");
            record.removeAll("_attachment_charset");
            record.removeAll("_attachment_name");
            if (name != null && name.length() > 0) {
                record.put("_attachment_name", (Object)name);
            }
            boolean bl = child.process(record);
            return bl;
        }
        finally {
            Closeables.closeQuietly((Closeable)tmp);
        }
    }
}

