/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flume.conf.FlumeConfiguration;
import org.apache.flume.node.AbstractConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileConfigurationProvider
extends AbstractConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileConfigurationProvider.class);
    private final File file;

    public PropertiesFileConfigurationProvider(String agentName, File file) {
        super(agentName);
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlumeConfiguration getFlumeConfiguration() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.file));
            Properties properties = new Properties();
            properties.load(reader);
            FlumeConfiguration flumeConfiguration = new FlumeConfiguration(this.toMap(properties));
            return flumeConfiguration;
        }
        catch (IOException ex) {
            LOGGER.error("Unable to load file:" + this.file + " (I/O failure) - Exception follows.", (Throwable)ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Unable to close file reader for file: " + this.file, (Throwable)ex);
                }
            }
        }
        return new FlumeConfiguration(new HashMap());
    }

    private Map<String, String> toMap(Properties properties) {
        HashMap result = Maps.newHashMap();
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            String value = properties.getProperty(name);
            result.put(name, value);
        }
        return result;
    }
}

