/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.servlet.SolrRequestParser;
import org.apache.solr.servlet.SolrRequestParsers;

class FormDataRequestParser
implements SolrRequestParser {
    private final int uploadLimitKB;

    public FormDataRequestParser(int limit) {
        this.uploadLimitKB = limit;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SolrParams parseParamsAndFillStreams(HttpServletRequest req, ArrayList<ContentStream> streams) throws Exception {
        long maxLength;
        long totalLength;
        if (!this.isFormData(req)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Not application/x-www-form-urlencoded content: " + req.getContentType());
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        String qs = req.getQueryString();
        if (qs != null) {
            SolrRequestParsers.parseQueryString(qs, map);
        }
        if ((totalLength = (long)req.getContentLength()) > (maxLength = (long)this.uploadLimitKB * 1024L)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "application/x-www-form-urlencoded content length (" + totalLength + " bytes) exceeds upload limit of " + this.uploadLimitKB + " KB");
        }
        String cs = ContentStreamBase.getCharsetFromContentType((String)req.getContentType());
        Charset charset = cs == null ? IOUtils.CHARSET_UTF_8 : Charset.forName(cs);
        ServletInputStream in = null;
        try {
            in = req.getInputStream();
            long bytesRead = SolrRequestParsers.parseFormDataContent((InputStream)FastInputStream.wrap((InputStream)in), maxLength, charset, map);
            if (bytesRead == 0L && totalLength > 0L) {
                throw this.getParameterIncompatibilityException();
            }
        }
        catch (IOException ioe) {
            try {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)ioe);
                catch (IllegalStateException ise) {
                    throw (SolrException)this.getParameterIncompatibilityException().initCause((Throwable)ise);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        return new MultiMapSolrParams(map);
    }

    private SolrException getParameterIncompatibilityException() {
        return new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Solr requires that request parameters sent using application/x-www-form-urlencoded content-type can be read through the request input stream. Unfortunately, the stream was empty / not available. This may be caused by another servlet filter calling ServletRequest.getParameter*() before SolrDispatchFilter, please remove it.");
    }

    public boolean isFormData(HttpServletRequest req) {
        String contentType = req.getContentType();
        if (contentType != null) {
            int idx = contentType.indexOf(59);
            if (idx > 0) {
                contentType = contentType.substring(0, idx);
            }
            if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType = contentType.trim())) {
                return true;
            }
        }
        return false;
    }
}

