/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.InputStream;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.util.SystemIdResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class ClassicIndexSchemaFactory
extends IndexSchemaFactory {
    private static final Logger log = LoggerFactory.getLogger(ClassicIndexSchemaFactory.class);

    @Override
    public void init(NamedList args) {
        if (args.size() > 0) {
            String msg = "Unexpected arg(s): " + args;
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
    }

    @Override
    public IndexSchema create(String resourceName, SolrConfig config) {
        SolrResourceLoader loader = config.getResourceLoader();
        InputStream schemaInputStream = null;
        if (null == resourceName) {
            resourceName = "schema.xml";
        }
        try {
            schemaInputStream = loader.openSchema(resourceName);
        }
        catch (Exception e) {
            String msg = "Error loading schema resource " + resourceName;
            log.error(msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
        }
        InputSource inputSource = new InputSource(schemaInputStream);
        inputSource.setSystemId(SystemIdResolver.createSystemIdFromResourceName(resourceName));
        IndexSchema schema = new IndexSchema(config, resourceName, inputSource);
        return schema;
    }
}

