/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.schema.BaseFieldResource;
import org.apache.solr.rest.schema.BaseSchemaResource;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFieldCollectionResource
extends BaseFieldResource
implements GETable {
    private static final Logger log = LoggerFactory.getLogger(CopyFieldCollectionResource.class);
    private static final String SOURCE_FIELD_LIST = "source.fl";
    private static final String DESTINATION_FIELD_LIST = "dest.fl";
    private Set<String> requestedSourceFields;
    private Set<String> requestedDestinationFields;

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            String[] fields;
            String destinationFieldListParam;
            String[] fields2;
            String sourceFieldListParam = this.getSolrRequest().getParams().get(SOURCE_FIELD_LIST);
            if (null != sourceFieldListParam && (fields2 = sourceFieldListParam.trim().split("[,\\s]+")).length > 0) {
                this.requestedSourceFields = new HashSet<String>(Arrays.asList(fields2));
                this.requestedSourceFields.remove("");
            }
            if (null != (destinationFieldListParam = this.getSolrRequest().getParams().get(DESTINATION_FIELD_LIST)) && (fields = destinationFieldListParam.trim().split("[,\\s]+")).length > 0) {
                this.requestedDestinationFields = new HashSet<String>(Arrays.asList(fields));
                this.requestedDestinationFields.remove("");
            }
        }
    }

    @Override
    public Representation get() {
        try {
            this.getSolrResponse().add("copyFields", this.getSchema().getCopyFieldProperties(true, this.requestedSourceFields, this.requestedDestinationFields));
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSchemaResource.SolrOutputRepresentation();
    }
}

