/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.postingshighlight.DefaultPassageFormatter;
import org.apache.lucene.search.postingshighlight.Passage;
import org.apache.lucene.search.postingshighlight.PassageFormatter;
import org.apache.lucene.search.postingshighlight.PassageScorer;
import org.apache.lucene.search.postingshighlight.PostingsHighlighter;
import org.apache.lucene.search.postingshighlight.WholeBreakIterator;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.PluginInfoInitialized;

public class PostingsSolrHighlighter
extends SolrHighlighter
implements PluginInfoInitialized {
    @Override
    public void initalize(SolrConfig config) {
    }

    @Override
    public void init(PluginInfo info) {
    }

    @Override
    public NamedList<Object> doHighlighting(DocList docs, Query query, SolrQueryRequest req, String[] defaultFields) throws IOException {
        final SolrParams params = req.getParams();
        if (this.isHighlightingEnabled(params)) {
            SolrIndexSearcher searcher = req.getSearcher();
            int[] docIDs = this.toDocIDs(docs);
            String[] keys = this.getUniqueKeys(searcher, docIDs);
            int maxLength = params.getInt("hl.maxAnalyzedChars", 10000);
            String[] fieldNames = this.getHighlightFields(query, req, defaultFields);
            int[] maxPassages = new int[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                maxPassages[i] = params.getFieldInt(fieldNames[i], "hl.snippets", 1);
            }
            PostingsHighlighter highlighter = new PostingsHighlighter(maxLength){

                protected Passage[] getEmptyHighlight(String fieldName, BreakIterator bi, int maxPassages) {
                    boolean defaultSummary = params.getFieldBool(fieldName, "hl.defaultSummary", true);
                    if (defaultSummary) {
                        return super.getEmptyHighlight(fieldName, bi, maxPassages);
                    }
                    return new Passage[0];
                }

                protected PassageFormatter getFormatter(String fieldName) {
                    String preTag = params.getFieldParam(fieldName, "hl.tag.pre", "<em>");
                    String postTag = params.getFieldParam(fieldName, "hl.tag.post", "</em>");
                    String ellipsis = params.getFieldParam(fieldName, "hl.tag.ellipsis", "... ");
                    String encoder = params.getFieldParam(fieldName, "hl.encoder", "simple");
                    return new DefaultPassageFormatter(preTag, postTag, ellipsis, "html".equals(encoder));
                }

                protected PassageScorer getScorer(String fieldName) {
                    float k1 = params.getFieldFloat(fieldName, "hl.score.k1", 1.2f);
                    float b = params.getFieldFloat(fieldName, "hl.score.b", 0.75f);
                    float pivot = params.getFieldFloat(fieldName, "hl.score.pivot", 87.0f);
                    return new PassageScorer(k1, b, pivot);
                }

                protected BreakIterator getBreakIterator(String field) {
                    String language = params.getFieldParam(field, "hl.bs.language");
                    String country = params.getFieldParam(field, "hl.bs.country");
                    String variant = params.getFieldParam(field, "hl.bs.variant");
                    Locale locale = PostingsSolrHighlighter.this.parseLocale(language, country, variant);
                    String type = params.getFieldParam(field, "hl.bs.type");
                    return PostingsSolrHighlighter.this.parseBreakIterator(type, locale);
                }
            };
            Map snippets = highlighter.highlightFields(fieldNames, query, (IndexSearcher)searcher, docIDs, maxPassages);
            return this.encodeSnippets(keys, fieldNames, snippets);
        }
        return null;
    }

    protected NamedList<Object> encodeSnippets(String[] keys, String[] fieldNames, Map<String, String[]> snippets) {
        SimpleOrderedMap list = new SimpleOrderedMap();
        for (int i = 0; i < keys.length; ++i) {
            SimpleOrderedMap summary = new SimpleOrderedMap();
            for (String field : fieldNames) {
                String snippet = snippets.get(field)[i];
                if (snippet == null) {
                    summary.add(field, (Object)new String[0]);
                    continue;
                }
                summary.add(field, (Object)new String[]{snippet});
            }
            list.add(keys[i], (Object)summary);
        }
        return list;
    }

    protected int[] toDocIDs(DocList docs) {
        int[] docIDs = new int[docs.size()];
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < docIDs.length; ++i) {
            if (!iterator.hasNext()) {
                throw new AssertionError();
            }
            docIDs[i] = iterator.nextDoc();
        }
        if (iterator.hasNext()) {
            throw new AssertionError();
        }
        return docIDs;
    }

    protected String[] getUniqueKeys(SolrIndexSearcher searcher, int[] docIDs) throws IOException {
        IndexSchema schema = searcher.getSchema();
        SchemaField keyField = schema.getUniqueKeyField();
        if (keyField != null) {
            Set<String> selector = Collections.singleton(keyField.getName());
            String[] uniqueKeys = new String[docIDs.length];
            for (int i = 0; i < docIDs.length; ++i) {
                String id;
                int docid = docIDs[i];
                Document doc = searcher.doc(docid, selector);
                uniqueKeys[i] = id = schema.printableUniqueKey(doc);
            }
            return uniqueKeys;
        }
        return new String[docIDs.length];
    }

    protected BreakIterator parseBreakIterator(String type, Locale locale) {
        if (type == null || "SENTENCE".equals(type)) {
            return BreakIterator.getSentenceInstance(locale);
        }
        if ("LINE".equals(type)) {
            return BreakIterator.getLineInstance(locale);
        }
        if ("WORD".equals(type)) {
            return BreakIterator.getWordInstance(locale);
        }
        if ("CHARACTER".equals(type)) {
            return BreakIterator.getCharacterInstance(locale);
        }
        if ("WHOLE".equals(type)) {
            return new WholeBreakIterator();
        }
        throw new IllegalArgumentException("Unknown hl.bs.type: " + type);
    }

    protected Locale parseLocale(String language, String country, String variant) {
        if (language == null && country == null && variant == null) {
            return Locale.ROOT;
        }
        if (language != null && country == null && variant != null) {
            throw new IllegalArgumentException("To specify variant, country is required");
        }
        if (language != null && country != null && variant != null) {
            return new Locale(language, country, variant);
        }
        if (language != null && country != null) {
            return new Locale(language, country);
        }
        return new Locale(language);
    }
}

