/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene42.Lucene42Codec;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;

public class SchemaCodecFactory
extends CodecFactory
implements SchemaAware {
    private Codec codec;

    @Override
    public void inform(final IndexSchema schema) {
        this.codec = new Lucene42Codec(){

            public PostingsFormat getPostingsFormatForField(String field) {
                SchemaField fieldOrNull = schema.getFieldOrNull(field);
                if (fieldOrNull == null) {
                    throw new IllegalArgumentException("no such field " + field);
                }
                String postingsFormatName = fieldOrNull.getType().getPostingsFormat();
                if (postingsFormatName != null) {
                    return PostingsFormat.forName((String)postingsFormatName);
                }
                return super.getPostingsFormatForField(field);
            }

            public DocValuesFormat getDocValuesFormatForField(String field) {
                SchemaField fieldOrNull = schema.getFieldOrNull(field);
                if (fieldOrNull == null) {
                    throw new IllegalArgumentException("no such field " + field);
                }
                String docValuesFormatName = fieldOrNull.getType().getDocValuesFormat();
                if (docValuesFormatName != null) {
                    return DocValuesFormat.forName((String)docValuesFormatName);
                }
                return super.getDocValuesFormatForField(field);
            }
        };
    }

    @Override
    public Codec getCodec() {
        assert (this.codec != null) : "inform must be called first";
        return this.codec;
    }
}

