/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.cloud.AssignShard;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.OverseerCollectionProcessor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClosableThread;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overseer {
    public static final String QUEUE_OPERATION = "operation";
    public static final String REMOVECOLLECTION = "removecollection";
    private static final int STATE_UPDATE_DELAY = 1500;
    private static Logger log = LoggerFactory.getLogger(Overseer.class);
    private OverseerThread ccThread;
    private OverseerThread updaterThread;
    private volatile boolean isClosed;
    private ZkStateReader reader;
    private ShardHandler shardHandler;
    private String adminPath;

    public Overseer(ShardHandler shardHandler, String adminPath, ZkStateReader reader) throws KeeperException, InterruptedException {
        this.reader = reader;
        this.shardHandler = shardHandler;
        this.adminPath = adminPath;
    }

    public void start(String id) {
        log.info("Overseer (id=" + id + ") starting");
        Overseer.createOverseerNode(this.reader.getZkClient());
        ThreadGroup tg = new ThreadGroup("Overseer state updater.");
        this.updaterThread = new OverseerThread(tg, new ClusterStateUpdater(this.reader, id));
        this.updaterThread.setDaemon(true);
        ThreadGroup ccTg = new ThreadGroup("Overseer collection creation process.");
        this.ccThread = new OverseerThread(ccTg, new OverseerCollectionProcessor(this.reader, id, this.shardHandler, this.adminPath), "Overseer-" + id);
        this.ccThread.setDaemon(true);
        this.updaterThread.start();
        this.ccThread.start();
    }

    public void close() {
        this.isClosed = true;
        if (this.updaterThread != null) {
            try {
                this.updaterThread.close();
                this.updaterThread.interrupt();
            }
            catch (Throwable t) {
                log.error("Error closing updaterThread", t);
            }
        }
        if (this.ccThread != null) {
            try {
                this.ccThread.close();
                this.ccThread.interrupt();
            }
            catch (Throwable t) {
                log.error("Error closing ccThread", t);
            }
        }
        try {
            this.reader.close();
        }
        catch (Throwable t) {
            log.error("Error closing zkStateReader", t);
        }
    }

    public static DistributedQueue getInQueue(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue", null);
    }

    static DistributedQueue getInternalQueue(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue-work", null);
    }

    static DistributedQueue getCollectionQueue(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/collection-queue-work", null);
    }

    private static void createOverseerNode(SolrZkClient zkClient) {
        try {
            zkClient.create("/overseer", new byte[0], CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
        }
        catch (InterruptedException e) {
            log.error("Could not create Overseer node", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (KeeperException e) {
            log.error("Could not create Overseer node", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    class OverseerThread
    extends Thread
    implements ClosableThread {
        private volatile boolean isClosed;

        public OverseerThread(ThreadGroup tg, ClusterStateUpdater clusterStateUpdater) {
            super(tg, clusterStateUpdater);
        }

        public OverseerThread(ThreadGroup ccTg, OverseerCollectionProcessor overseerCollectionProcessor, String string) {
            super(ccTg, overseerCollectionProcessor, string);
        }

        public void close() {
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }

    private class ClusterStateUpdater
    implements Runnable,
    ClosableThread {
        private static final String DELETECORE = "deletecore";
        private final ZkStateReader reader;
        private final SolrZkClient zkClient;
        private final String myId;
        private final DistributedQueue stateUpdateQueue;
        private final DistributedQueue workQueue;
        private volatile boolean isClosed;

        public ClusterStateUpdater(ZkStateReader reader, String myId) {
            this.zkClient = reader.getZkClient();
            this.stateUpdateQueue = Overseer.getInQueue(this.zkClient);
            this.workQueue = Overseer.getInternalQueue(this.zkClient);
            this.myId = myId;
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String operation;
            ZkNodeProps message;
            ClusterState clusterState;
            byte[] head;
            Object object;
            if (!this.isClosed && this.amILeader()) {
                object = this.reader.getUpdateLock();
                synchronized (object) {
                    try {
                        head = this.workQueue.peek();
                        if (head != null) {
                            this.reader.updateClusterState(true);
                            clusterState = this.reader.getClusterState();
                            log.info("Replaying operations from work queue.");
                            while (head != null && this.amILeader()) {
                                message = ZkNodeProps.load((byte[])head);
                                operation = message.getStr(Overseer.QUEUE_OPERATION);
                                clusterState = this.processMessage(clusterState, message, operation);
                                this.zkClient.setData("/clusterstate.json", ZkStateReader.toJSON((Object)clusterState), true);
                                this.workQueue.poll();
                                head = this.workQueue.peek();
                            }
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED) {
                            log.warn("Solr cannot talk to ZK, exiting Overseer work queue loop", (Throwable)e);
                            return;
                        }
                        log.error("Exception in Overseer work queue loop", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (Exception e) {
                        log.error("Exception in Overseer work queue loop", (Throwable)e);
                    }
                }
            }
            log.info("Starting to work on the main queue");
            while (!this.isClosed && this.amILeader()) {
                object = this.reader.getUpdateLock();
                synchronized (object) {
                    try {
                        head = this.stateUpdateQueue.peek();
                        if (head != null) {
                            this.reader.updateClusterState(true);
                            clusterState = this.reader.getClusterState();
                            while (head != null) {
                                message = ZkNodeProps.load((byte[])head);
                                operation = message.getStr(Overseer.QUEUE_OPERATION);
                                clusterState = this.processMessage(clusterState, message, operation);
                                this.workQueue.offer(head);
                                this.stateUpdateQueue.poll();
                                head = this.stateUpdateQueue.peek();
                            }
                            this.zkClient.setData("/clusterstate.json", ZkStateReader.toJSON((Object)clusterState), true);
                        }
                        while (this.workQueue.poll() != null) {
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED) {
                            log.warn("Solr cannot talk to ZK, exiting Overseer main queue loop", (Throwable)e);
                            return;
                        }
                        log.error("Exception in Overseer main queue loop", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (Exception e) {
                        log.error("Exception in Overseer main queue loop", (Throwable)e);
                    }
                }
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private ClusterState processMessage(ClusterState clusterState, ZkNodeProps message, String operation) {
            if ("state".equals(operation)) {
                clusterState = this.updateState(clusterState, message);
            } else if (DELETECORE.equals(operation)) {
                clusterState = this.removeCore(clusterState, message);
            } else if (Overseer.REMOVECOLLECTION.equals(operation)) {
                clusterState = this.removeCollection(clusterState, message);
            } else if ("leader".equals(operation)) {
                StringBuilder sb = new StringBuilder();
                String baseUrl = message.getStr("base_url");
                String coreName = message.getStr("core");
                sb.append(baseUrl);
                if (baseUrl != null && !baseUrl.endsWith("/")) {
                    sb.append("/");
                }
                sb.append(coreName == null ? "" : coreName);
                if (!sb.substring(sb.length() - 1).equals("/")) {
                    sb.append("/");
                }
                clusterState = this.setShardLeader(clusterState, message.getStr("collection"), message.getStr("shard"), sb.length() > 0 ? sb.toString() : null);
            } else if ("createshard".equals(operation)) {
                clusterState = this.createShard(clusterState, message);
            } else if ("updateshardstate".equals(operation)) {
                clusterState = this.updateShardState(clusterState, message);
            } else {
                throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
            }
            return clusterState;
        }

        private ClusterState updateShardState(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("collection");
            log.info("Update shard state invoked for collection: " + collection);
            for (String key : message.keySet()) {
                if ("collection".equals(key) || Overseer.QUEUE_OPERATION.equals(key)) continue;
                Slice slice = clusterState.getSlice(collection, key);
                if (slice == null) {
                    throw new RuntimeException("Overseer.updateShardState unknown collection: " + collection + " slice: " + key);
                }
                log.info("Update shard state " + key + " to " + message.getStr(key));
                Map props = slice.shallowCopy();
                props.put(Slice.STATE, message.getStr(key));
                Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props);
                clusterState = this.updateSlice(clusterState, collection, newSlice);
            }
            return clusterState;
        }

        private ClusterState createShard(ClusterState clusterState, ZkNodeProps message) {
            String shardId;
            String collection = message.getStr("collection");
            Slice slice = clusterState.getSlice(collection, shardId = message.getStr("shard"));
            if (slice == null) {
                Map replicas = Collections.EMPTY_MAP;
                HashMap<String, String> sliceProps = new HashMap<String, String>();
                String shardRange = message.getStr("shard_range");
                String shardState = message.getStr("shard_state");
                sliceProps.put(Slice.RANGE, shardRange);
                sliceProps.put(Slice.STATE, shardState);
                slice = new Slice(shardId, replicas, sliceProps);
                clusterState = this.updateSlice(clusterState, collection, slice);
            } else {
                log.error("Unable to create Shard: " + shardId + " because it already exists in collection: " + collection);
            }
            return clusterState;
        }

        private boolean amILeader() {
            try {
                ZkNodeProps props = ZkNodeProps.load((byte[])this.zkClient.getData("/overseer_elect/leader", null, null, true));
                if (this.myId.equals(props.getStr("id"))) {
                    return true;
                }
            }
            catch (KeeperException e) {
                log.warn("", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
            return false;
        }

        private ClusterState updateState(ClusterState state, ZkNodeProps message) {
            Map<String, Replica> replicas;
            String sliceName;
            String collection = message.getStr("collection");
            String coreNodeName = message.getStr("core_node_name");
            if (coreNodeName == null) {
                coreNodeName = message.getStr("node_name") + "_" + message.getStr("core");
            }
            Integer numShards = message.getStr("numShards") != null ? Integer.valueOf(Integer.parseInt(message.getStr("numShards"))) : null;
            log.info("Update state numShards={} message={}", (Object)numShards, (Object)message);
            boolean collectionExists = state.getCollections().contains(collection);
            if (!collectionExists && numShards != null) {
                state = this.createCollection(state, collection, numShards);
            }
            if ((sliceName = message.getStr("shard")) == null && (sliceName = this.getAssignedId(state, coreNodeName, message)) != null) {
                log.info("shard=" + sliceName + " is already registered");
            }
            if (sliceName == null) {
                if (collectionExists) {
                    numShards = ((DocCollection)state.getCollectionStates().get(collection)).getSlices().size();
                    log.info("Collection already exists with numShards=" + numShards);
                }
                sliceName = AssignShard.assignShard(collection, state, numShards);
                log.info("Assigning new node to shard=" + sliceName);
            }
            Slice slice = state.getSlice(collection, sliceName);
            LinkedHashMap<String, Object> replicaProps = new LinkedHashMap<String, Object>();
            replicaProps.putAll(message.getProperties());
            if (slice != null) {
                String sliceState = slice.getState();
                Replica oldReplica = (Replica)slice.getReplicasMap().get(coreNodeName);
                if (oldReplica != null && oldReplica.containsKey("leader")) {
                    replicaProps.put("leader", oldReplica.get("leader"));
                }
            }
            replicaProps.remove("numShards");
            replicaProps.remove(Overseer.QUEUE_OPERATION);
            Set entrySet = replicaProps.entrySet();
            ArrayList removeKeys = new ArrayList();
            for (Map.Entry entry : entrySet) {
                if (entry.getValue() != null) continue;
                removeKeys.add(entry.getKey());
            }
            for (String removeKey : removeKeys) {
                replicaProps.remove(removeKey);
            }
            replicaProps.remove("core_node_name");
            String shardRange = (String)replicaProps.remove("shard_range");
            String shardState = (String)replicaProps.remove("shard_state");
            Replica replica = new Replica(coreNodeName, replicaProps);
            HashMap<String, String> sliceProps = null;
            if (slice != null) {
                sliceProps = slice.getProperties();
                replicas = slice.getReplicasCopy();
            } else {
                replicas = new HashMap(1);
                sliceProps = new HashMap<String, String>();
                sliceProps.put(Slice.RANGE, shardRange);
                sliceProps.put(Slice.STATE, shardState);
            }
            replicas.put(replica.getName(), replica);
            slice = new Slice(sliceName, replicas, sliceProps);
            ClusterState newClusterState = this.updateSlice(state, collection, slice);
            return newClusterState;
        }

        private Map<String, Object> defaultCollectionProps() {
            HashMap<String, Object> props = new HashMap<String, Object>(2);
            props.put("router", "compositeId");
            return props;
        }

        private ClusterState createCollection(ClusterState state, String collectionName, int numShards) {
            log.info("Create collection {} with numShards {}", (Object)collectionName, (Object)numShards);
            DocRouter router = DocRouter.DEFAULT;
            List ranges = router.partitionRange(numShards, router.fullRange());
            LinkedHashMap<String, DocCollection> newCollections = new LinkedHashMap<String, DocCollection>();
            LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
            newCollections.putAll(state.getCollectionStates());
            for (int i = 0; i < numShards; ++i) {
                String sliceName = "shard" + (i + 1);
                LinkedHashMap sliceProps = new LinkedHashMap(1);
                sliceProps.put(Slice.RANGE, ranges.get(i));
                newSlices.put(sliceName, new Slice(sliceName, null, sliceProps));
            }
            Map<String, Object> collectionProps = this.defaultCollectionProps();
            DocCollection newCollection = new DocCollection(collectionName, newSlices, collectionProps, router);
            newCollections.put(collectionName, newCollection);
            ClusterState newClusterState = new ClusterState(state.getLiveNodes(), newCollections);
            return newClusterState;
        }

        private String getAssignedId(ClusterState state, String nodeName, ZkNodeProps coreState) {
            Collection slices = state.getSlices(coreState.getStr("collection"));
            if (slices != null) {
                for (Slice slice : slices) {
                    if (slice.getReplicasMap().get(nodeName) == null) continue;
                    return slice.getName();
                }
            }
            return null;
        }

        private ClusterState updateSlice(ClusterState state, String collectionName, Slice slice) {
            DocRouter router;
            HashMap<String, String> props;
            HashMap<String, Slice> slices;
            LinkedHashMap<String, DocCollection> newCollections = new LinkedHashMap<String, DocCollection>(state.getCollectionStates());
            DocCollection coll = (DocCollection)newCollections.get(collectionName);
            if (coll == null) {
                slices = new HashMap<String, Slice>(1);
                props = new HashMap<String, String>(1);
                props.put("router", "implicit");
                router = new ImplicitDocRouter();
            } else {
                props = coll.getProperties();
                router = coll.getRouter();
                slices = new LinkedHashMap(coll.getSlicesMap());
            }
            slices.put(slice.getName(), slice);
            DocCollection newCollection = new DocCollection(collectionName, slices, props, router);
            newCollections.put(collectionName, newCollection);
            return new ClusterState(state.getLiveNodes(), newCollections);
        }

        private ClusterState setShardLeader(ClusterState state, String collectionName, String sliceName, String leaderUrl) {
            LinkedHashMap<String, DocCollection> newCollections = new LinkedHashMap<String, DocCollection>(state.getCollectionStates());
            DocCollection coll = (DocCollection)newCollections.get(collectionName);
            if (coll == null) {
                log.error("Could not mark shard leader for non existing collection:" + collectionName);
                return state;
            }
            LinkedHashMap<String, Slice> slices = coll.getSlicesMap();
            Slice slice = (Slice)(slices = new LinkedHashMap<String, Slice>(slices)).get(sliceName);
            if (slice == null) {
                slice = coll.getSlice(sliceName);
            }
            if (slice == null) {
                log.error("Could not mark leader for non existing/active slice:" + sliceName);
                return state;
            }
            Replica oldLeader = slice.getLeader();
            LinkedHashMap<String, Replica> newReplicas = new LinkedHashMap<String, Replica>();
            for (Replica replica : slice.getReplicas()) {
                LinkedHashMap<String, String> replicaProps;
                String coreURL = ZkCoreNodeProps.getCoreUrl((String)replica.getStr("base_url"), (String)replica.getStr("core"));
                if (replica == oldLeader && !coreURL.equals(leaderUrl)) {
                    replicaProps = new LinkedHashMap<String, String>(replica.getProperties());
                    replicaProps.remove(Slice.LEADER);
                    replica = new Replica(replica.getName(), replicaProps);
                } else if (coreURL.equals(leaderUrl)) {
                    replicaProps = new LinkedHashMap(replica.getProperties());
                    replicaProps.put(Slice.LEADER, "true");
                    replica = new Replica(replica.getName(), replicaProps);
                }
                newReplicas.put(replica.getName(), replica);
            }
            Map newSliceProps = slice.shallowCopy();
            newSliceProps.put(Slice.REPLICAS, newReplicas);
            Slice newSlice = new Slice(slice.getName(), newReplicas, slice.getProperties());
            slices.put(newSlice.getName(), newSlice);
            DocCollection newCollection = new DocCollection(coll.getName(), slices, coll.getProperties(), coll.getRouter());
            newCollections.put(collectionName, newCollection);
            return new ClusterState(state.getLiveNodes(), newCollections);
        }

        private ClusterState removeCollection(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("name");
            LinkedHashMap newCollections = new LinkedHashMap(clusterState.getCollectionStates());
            newCollections.remove(collection);
            ClusterState newState = new ClusterState(clusterState.getLiveNodes(), newCollections);
            return newState;
        }

        private ClusterState removeCore(ClusterState clusterState, ZkNodeProps message) {
            String cnn = message.getStr("core_node_name");
            if (cnn == null) {
                cnn = message.getStr("node_name") + "_" + message.getStr("core");
            }
            String collection = message.getStr("collection");
            LinkedHashMap<String, DocCollection> newCollections = new LinkedHashMap<String, DocCollection>(clusterState.getCollectionStates());
            DocCollection coll = (DocCollection)newCollections.get(collection);
            if (coll == null) {
                return clusterState;
            }
            LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
            boolean lastSlice = false;
            for (Slice slice : coll.getSlices()) {
                Replica replica = slice.getReplica(cnn);
                if (replica != null) {
                    Map newReplicas = slice.getReplicasCopy();
                    newReplicas.remove(cnn);
                    if (newReplicas.size() == 0) {
                        slice = null;
                        lastSlice = true;
                    } else {
                        slice = new Slice(slice.getName(), newReplicas, slice.getProperties());
                    }
                }
                if (slice == null) continue;
                newSlices.put(slice.getName(), slice);
            }
            if (lastSlice) {
                for (Slice slice : coll.getSlices()) {
                    if (slice.getReplicas().size() != 0) continue;
                    newSlices.remove(slice.getName());
                }
            }
            if (newSlices.size() == 0) {
                newCollections.remove(coll.getName());
                try {
                    this.zkClient.clean("/collections/" + collection);
                }
                catch (InterruptedException e) {
                    SolrException.log((Logger)log, (String)("Cleaning up collection in zk was interrupted:" + collection), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (KeeperException e) {
                    SolrException.log((Logger)log, (String)("Problem cleaning up collection in zk:" + collection), (Throwable)e);
                }
            } else {
                DocCollection newCollection = new DocCollection(coll.getName(), newSlices, coll.getProperties(), coll.getRouter());
                newCollections.put(newCollection.getName(), newCollection);
            }
            ClusterState newState = new ClusterState(clusterState.getLiveNodes(), newCollections);
            return newState;
        }

        public void close() {
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }
}

