/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hbase;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.flume.sink.hdfs.KerberosUser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSinkSecurityManager {
    private static volatile KerberosUser loggedInUser;
    private static final String FLUME_KEYTAB_KEY = "flume.keytab.key";
    private static final String FLUME_PRINCIPAL_KEY = "flume.principal.key";
    private static final Logger LOG;

    public static boolean isSecurityEnabled(Configuration conf) {
        return User.isSecurityEnabled() && User.isHBaseSecurityEnabled((Configuration)conf);
    }

    public static synchronized User login(Configuration conf, String hostname, String kerberosPrincipal, String kerberosKeytab) throws IOException {
        if (kerberosPrincipal.isEmpty()) {
            String msg = "Login failed, since kerberos principal was not specified.";
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if (kerberosKeytab.isEmpty()) {
            String msg = "Login failed, since kerberos keytab was not specified.";
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        File kfile = new File(kerberosKeytab);
        if (!kfile.isFile() || !kfile.canRead()) {
            throw new IllegalArgumentException("The keyTab file: " + kerberosKeytab + " is nonexistent or can't read. " + "Please specify a readable keytab file for Kerberos auth.");
        }
        String principal = kerberosPrincipal;
        try {
            principal = SecurityUtil.getServerPrincipal((String)kerberosPrincipal, (String)"");
        }
        catch (IOException e) {
            LOG.error("Host lookup error resolving kerberos principal (" + kerberosPrincipal + "). Exception follows.", (Throwable)e);
            throw e;
        }
        Preconditions.checkNotNull((Object)principal, (Object)"Principal must not be null");
        KerberosUser newUser = new KerberosUser(principal, kerberosKeytab);
        User hbaseUser = null;
        boolean loggedIn = false;
        if (loggedInUser != null) {
            Preconditions.checkArgument((boolean)newUser.equals((Object)loggedInUser), (Object)"Cannot switch kerberos credentials during a reconfiguration. Please restart the agent to set the new credentials.");
            try {
                hbaseUser = User.create((UserGroupInformation)UserGroupInformation.getLoginUser());
                loggedIn = true;
            }
            catch (IOException ex) {
                LOG.warn("Previous login does not exist, will authenticate against KDC");
            }
        }
        if (!loggedIn) {
            if (hostname == null || hostname.isEmpty()) {
                hostname = InetAddress.getLocalHost().getCanonicalHostName();
            }
            conf.set(FLUME_KEYTAB_KEY, kerberosKeytab);
            conf.set(FLUME_PRINCIPAL_KEY, principal);
            User.login((Configuration)conf, (String)FLUME_KEYTAB_KEY, (String)FLUME_PRINCIPAL_KEY, (String)hostname);
            hbaseUser = User.create((UserGroupInformation)UserGroupInformation.getLoginUser());
            loggedInUser = newUser;
            LOG.info("Logged into HBase as user: " + hbaseUser.getName());
        }
        return hbaseUser;
    }

    static {
        LOG = LoggerFactory.getLogger(HBaseSinkSecurityManager.class);
    }
}

