/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.flume.channel.file.Commit;
import org.apache.flume.channel.file.CorruptEventException;
import org.apache.flume.channel.file.FlumeEventPointer;
import org.apache.flume.channel.file.FlumeEventQueue;
import org.apache.flume.channel.file.LogFile;
import org.apache.flume.channel.file.LogFileFactory;
import org.apache.flume.channel.file.LogRecord;
import org.apache.flume.channel.file.Take;
import org.apache.flume.channel.file.TransactionEventRecord;
import org.apache.flume.channel.file.TransactionIDOracle;
import org.apache.flume.channel.file.WriteOrderOracle;
import org.apache.flume.channel.file.encryption.KeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplayHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReplayHandler.class);
    private final FlumeEventQueue queue;
    private final long lastCheckpoint;
    private final Map<Integer, LogFile.SequentialReader> readers;
    private final PriorityQueue<LogRecord> logRecordBuffer;
    private final KeyProvider encryptionKeyProvider;
    private final List<Long> pendingTakes;
    int readCount = 0;
    int putCount = 0;
    int takeCount = 0;
    int rollbackCount = 0;
    int commitCount = 0;
    int skipCount = 0;

    @VisibleForTesting
    public int getReadCount() {
        return this.readCount;
    }

    @VisibleForTesting
    public int getPutCount() {
        return this.putCount;
    }

    @VisibleForTesting
    public int getTakeCount() {
        return this.takeCount;
    }

    @VisibleForTesting
    public int getCommitCount() {
        return this.commitCount;
    }

    @VisibleForTesting
    public int getRollbackCount() {
        return this.rollbackCount;
    }

    ReplayHandler(FlumeEventQueue queue, @Nullable KeyProvider encryptionKeyProvider) {
        this.queue = queue;
        this.lastCheckpoint = queue.getLogWriteOrderID();
        this.pendingTakes = Lists.newArrayList();
        this.readers = Maps.newHashMap();
        this.logRecordBuffer = new PriorityQueue();
        this.encryptionKeyProvider = encryptionKeyProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    void replayLogv1(List<File> logs) throws Exception {
        int total = 0;
        int count = 0;
        MultiValueMap transactionMap = new MultiValueMap();
        SetMultimap<Long, Long> inflightPuts = this.queue.deserializeInflightPuts();
        for (Long txnID : inflightPuts.keySet()) {
            Set eventPointers = inflightPuts.get((Object)txnID);
            for (Long eventPointer : eventPointers) {
                transactionMap.put((Object)txnID, (Object)FlumeEventPointer.fromLong(eventPointer));
            }
        }
        SetMultimap<Long, Long> inflightTakes = this.queue.deserializeInflightTakes();
        LOG.info("Starting replay of " + logs);
        for (File log : logs) {
            LOG.info("Replaying " + log);
            LogFile.SequentialReader reader = null;
            try {
                LogRecord entry;
                reader = LogFileFactory.getSequentialReader(log, this.encryptionKeyProvider);
                reader.skipToLastCheckpointPosition(this.queue.getLogWriteOrderID());
                int fileId = reader.getLogFileID();
                while ((entry = reader.next()) != null) {
                    int offset = entry.getOffset();
                    TransactionEventRecord record = entry.getEvent();
                    short type = record.getRecordType();
                    long trans = record.getTransactionID();
                    ++this.readCount;
                    if (record.getLogWriteOrderID() > this.lastCheckpoint) {
                        FlumeEventPointer ptr;
                        if (type == TransactionEventRecord.Type.PUT.get()) {
                            ++this.putCount;
                            ptr = new FlumeEventPointer(fileId, offset);
                            transactionMap.put((Object)trans, (Object)ptr);
                            continue;
                        }
                        if (type == TransactionEventRecord.Type.TAKE.get()) {
                            ++this.takeCount;
                            Take take = (Take)record;
                            ptr = new FlumeEventPointer(take.getFileID(), take.getOffset());
                            transactionMap.put((Object)trans, (Object)ptr);
                            continue;
                        }
                        if (type == TransactionEventRecord.Type.ROLLBACK.get()) {
                            ++this.rollbackCount;
                            transactionMap.remove((Object)trans);
                            continue;
                        }
                        if (type == TransactionEventRecord.Type.COMMIT.get()) {
                            ++this.commitCount;
                            Collection pointers = (Collection)transactionMap.remove((Object)trans);
                            if (((Commit)record).getType() == TransactionEventRecord.Type.TAKE.get() && inflightTakes.containsKey((Object)trans)) {
                                if (pointers == null) {
                                    pointers = Sets.newHashSet();
                                }
                                Set takes = inflightTakes.removeAll((Object)trans);
                                for (Long take : takes) {
                                    pointers.add(FlumeEventPointer.fromLong(take));
                                }
                            }
                            if (pointers == null || pointers.size() <= 0) continue;
                            this.processCommit(((Commit)record).getType(), pointers);
                            count += pointers.size();
                            continue;
                        }
                        Preconditions.checkArgument((boolean)false, (Object)("Unknown record type: " + Integer.toHexString(type)));
                        continue;
                    }
                    ++this.skipCount;
                }
                LOG.info("Replayed " + count + " from " + log);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("read: " + this.readCount + ", put: " + this.putCount + ", take: " + this.takeCount + ", rollback: " + this.rollbackCount + ", commit: " + this.commitCount + ", skipp: " + this.skipCount);
            }
            catch (EOFException e) {
                LOG.warn("Hit EOF on " + log);
            }
            finally {
                total += count;
                count = 0;
                if (reader == null) continue;
                reader.close();
            }
        }
        int uncommittedTakes = 0;
        for (Long inflightTxnId : inflightTakes.keySet()) {
            Set inflightUncommittedTakes = inflightTakes.get((Object)inflightTxnId);
            for (Long inflightUncommittedTake : inflightUncommittedTakes) {
                this.queue.addHead(FlumeEventPointer.fromLong(inflightUncommittedTake));
                ++uncommittedTakes;
            }
        }
        inflightTakes.clear();
        count += uncommittedTakes;
        int pendingTakesSize = this.pendingTakes.size();
        if (pendingTakesSize > 0) {
            String msg = "Pending takes " + pendingTakesSize + " exist after the end of replay";
            if (LOG.isDebugEnabled()) {
                for (Long pointer : this.pendingTakes) {
                    LOG.debug("Pending take " + FlumeEventPointer.fromLong(pointer));
                }
            } else {
                LOG.error(msg + ". Duplicate messages will exist in destination.");
            }
        }
        LOG.info("Replayed " + total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replayLog(List<File> logs) throws Exception {
        int count = 0;
        MultiValueMap transactionMap = new MultiValueMap();
        long transactionIDSeed = this.lastCheckpoint;
        long writeOrderIDSeed = this.lastCheckpoint;
        LOG.info("Starting replay of " + logs);
        SetMultimap<Long, Long> inflightPuts = this.queue.deserializeInflightPuts();
        for (Long txnID : inflightPuts.keySet()) {
            Set eventPointers = inflightPuts.get((Object)txnID);
            for (Long eventPointer : eventPointers) {
                transactionMap.put((Object)txnID, (Object)FlumeEventPointer.fromLong(eventPointer));
            }
        }
        SetMultimap<Long, Long> inflightTakes = this.queue.deserializeInflightTakes();
        try {
            for (File log : logs) {
                LOG.info("Replaying " + log);
                try {
                    LogFile.SequentialReader reader = LogFileFactory.getSequentialReader(log, this.encryptionKeyProvider);
                    reader.skipToLastCheckpointPosition(this.queue.getLogWriteOrderID());
                    Preconditions.checkState((!this.readers.containsKey(reader.getLogFileID()) ? 1 : 0) != 0, (Object)("Readers " + this.readers + " already contains " + reader.getLogFileID()));
                    this.readers.put(reader.getLogFileID(), reader);
                    LogRecord logRecord = reader.next();
                    if (logRecord == null) {
                        this.readers.remove(reader.getLogFileID());
                        reader.close();
                        continue;
                    }
                    this.logRecordBuffer.add(logRecord);
                }
                catch (EOFException e) {
                    LOG.warn("Ignoring " + log + " due to EOF", (Throwable)e);
                }
            }
            LogRecord entry = null;
            FlumeEventPointer ptr = null;
            while ((entry = this.next()) != null) {
                int fileId = entry.getFileID();
                int offset = entry.getOffset();
                TransactionEventRecord record = entry.getEvent();
                short type = record.getRecordType();
                long trans = record.getTransactionID();
                transactionIDSeed = Math.max(transactionIDSeed, trans);
                writeOrderIDSeed = Math.max(writeOrderIDSeed, record.getLogWriteOrderID());
                ++this.readCount;
                if (this.readCount % 10000 == 0 && this.readCount > 0) {
                    LOG.info("Read " + this.readCount + " records");
                }
                if (record.getLogWriteOrderID() > this.lastCheckpoint) {
                    if (type == TransactionEventRecord.Type.PUT.get()) {
                        ++this.putCount;
                        ptr = new FlumeEventPointer(fileId, offset);
                        transactionMap.put((Object)trans, (Object)ptr);
                        continue;
                    }
                    if (type == TransactionEventRecord.Type.TAKE.get()) {
                        ++this.takeCount;
                        Take take = (Take)record;
                        ptr = new FlumeEventPointer(take.getFileID(), take.getOffset());
                        transactionMap.put((Object)trans, (Object)ptr);
                        continue;
                    }
                    if (type == TransactionEventRecord.Type.ROLLBACK.get()) {
                        ++this.rollbackCount;
                        transactionMap.remove((Object)trans);
                        continue;
                    }
                    if (type == TransactionEventRecord.Type.COMMIT.get()) {
                        ++this.commitCount;
                        Collection pointers = (Collection)transactionMap.remove((Object)trans);
                        if (((Commit)record).getType() == TransactionEventRecord.Type.TAKE.get() && inflightTakes.containsKey((Object)trans)) {
                            if (pointers == null) {
                                pointers = Sets.newHashSet();
                            }
                            Set takes = inflightTakes.removeAll((Object)trans);
                            for (Long take : takes) {
                                pointers.add(FlumeEventPointer.fromLong(take));
                            }
                        }
                        if (pointers == null || pointers.size() <= 0) continue;
                        this.processCommit(((Commit)record).getType(), pointers);
                        count += pointers.size();
                        continue;
                    }
                    Preconditions.checkArgument((boolean)false, (Object)("Unknown record type: " + Integer.toHexString(type)));
                    continue;
                }
                ++this.skipCount;
            }
            LOG.info("read: " + this.readCount + ", put: " + this.putCount + ", take: " + this.takeCount + ", rollback: " + this.rollbackCount + ", commit: " + this.commitCount + ", skip: " + this.skipCount + ", eventCount:" + count);
        }
        catch (Throwable throwable) {
            TransactionIDOracle.setSeed(transactionIDSeed);
            WriteOrderOracle.setSeed(writeOrderIDSeed);
            for (LogFile.SequentialReader reader : this.readers.values()) {
                if (reader == null) continue;
                reader.close();
            }
            throw throwable;
        }
        TransactionIDOracle.setSeed(transactionIDSeed);
        WriteOrderOracle.setSeed(writeOrderIDSeed);
        for (LogFile.SequentialReader reader : this.readers.values()) {
            if (reader == null) continue;
            reader.close();
        }
        int uncommittedTakes = 0;
        for (Long inflightTxnId : inflightTakes.keySet()) {
            Set inflightUncommittedTakes = inflightTakes.get((Object)inflightTxnId);
            for (Long inflightUncommittedTake : inflightUncommittedTakes) {
                this.queue.addHead(FlumeEventPointer.fromLong(inflightUncommittedTake));
                ++uncommittedTakes;
            }
        }
        inflightTakes.clear();
        count += uncommittedTakes;
        int pendingTakesSize = this.pendingTakes.size();
        if (pendingTakesSize > 0) {
            String msg = "Pending takes " + pendingTakesSize + " exist after the end of replay";
            if (LOG.isDebugEnabled()) {
                for (Long pointer : this.pendingTakes) {
                    LOG.debug("Pending take " + FlumeEventPointer.fromLong(pointer));
                }
            } else {
                LOG.error(msg + ". Duplicate messages will exist in destination.");
            }
        }
    }

    private LogRecord next() throws IOException, CorruptEventException {
        LogFile.SequentialReader reader;
        LogRecord nextLogRecord;
        LogRecord resultLogRecord = this.logRecordBuffer.poll();
        if (resultLogRecord != null && (nextLogRecord = (reader = this.readers.get(resultLogRecord.getFileID())).next()) != null) {
            this.logRecordBuffer.add(nextLogRecord);
        }
        return resultLogRecord;
    }

    private void processCommit(short type, Collection<FlumeEventPointer> pointers) {
        if (type == TransactionEventRecord.Type.PUT.get()) {
            for (FlumeEventPointer pointer : pointers) {
                if (!this.queue.addTail(pointer)) {
                    throw new IllegalStateException("Unable to add " + pointer + ". Queue depth = " + this.queue.getSize() + ", Capacity = " + this.queue.getCapacity());
                }
                if (!this.pendingTakes.remove(pointer.toLong())) continue;
                Preconditions.checkState((boolean)this.queue.remove(pointer), (Object)("Take was pending and pointer was successfully added to the queue but could not be removed: " + pointer));
            }
        } else if (type == TransactionEventRecord.Type.TAKE.get()) {
            for (FlumeEventPointer pointer : pointers) {
                boolean removed = this.queue.remove(pointer);
                if (removed) continue;
                this.pendingTakes.add(pointer.toLong());
            }
        } else {
            Preconditions.checkArgument((boolean)false, (Object)("Unknown record type: " + Integer.toHexString(type)));
        }
    }
}

