/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flume.channel.file.BadCheckpointException;
import org.apache.flume.channel.file.EventQueueBackingStoreFile;
import org.apache.flume.channel.file.EventQueueBackingStoreFileV2;
import org.apache.flume.channel.file.Serialization;
import org.apache.flume.channel.file.WriteOrderOracle;
import org.apache.flume.channel.file.proto.ProtosFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EventQueueBackingStoreFileV3
extends EventQueueBackingStoreFile {
    private static final Logger LOG = LoggerFactory.getLogger(EventQueueBackingStoreFileV3.class);
    private final File metaDataFile;

    EventQueueBackingStoreFileV3(File checkpointFile, int capacity, String name) throws IOException, BadCheckpointException {
        this(checkpointFile, capacity, name, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventQueueBackingStoreFileV3(File checkpointFile, int capacity, String name, File checkpointBackupDir, boolean backupCheckpoint) throws IOException, BadCheckpointException {
        super(capacity, name, checkpointFile, checkpointBackupDir, backupCheckpoint);
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)("capacity must be greater than 0 " + capacity));
        this.metaDataFile = Serialization.getMetaDataFile(checkpointFile);
        LOG.info("Starting up with " + checkpointFile + " and " + this.metaDataFile);
        if (this.metaDataFile.exists()) {
            FileInputStream inputStream = new FileInputStream(this.metaDataFile);
            try {
                LOG.info("Reading checkpoint metadata from " + this.metaDataFile);
                ProtosFactory.Checkpoint checkpoint = ProtosFactory.Checkpoint.parseDelimitedFrom(inputStream);
                if (checkpoint == null) {
                    throw new BadCheckpointException("The checkpoint metadata file does not exist or has zero length");
                }
                int version = checkpoint.getVersion();
                if (version != this.getVersion()) {
                    throw new BadCheckpointException("Invalid version: " + version + " " + name + ", expected " + this.getVersion());
                }
                long logWriteOrderID = checkpoint.getWriteOrderID();
                if (logWriteOrderID != this.getCheckpointLogWriteOrderID()) {
                    String msg = "Checkpoint and Meta files have differing logWriteOrderIDs " + this.getCheckpointLogWriteOrderID() + ", and " + logWriteOrderID;
                    LOG.warn(msg);
                    throw new BadCheckpointException(msg);
                }
                WriteOrderOracle.setSeed(logWriteOrderID);
                this.setLogWriteOrderID(logWriteOrderID);
                this.setSize(checkpoint.getQueueSize());
                this.setHead(checkpoint.getQueueHead());
                for (ProtosFactory.ActiveLog activeLog : checkpoint.getActiveLogsList()) {
                    Integer logFileID = activeLog.getLogFileID();
                    Integer count = activeLog.getCount();
                    this.logFileIDReferenceCounts.put(logFileID, new AtomicInteger(count));
                }
            }
            catch (InvalidProtocolBufferException ex) {
                throw new BadCheckpointException("Checkpoint metadata file is invalid. The agent might have been stopped while it was being written", ex);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.warn("Unable to close " + this.metaDataFile, (Throwable)e);
                }
            }
        }
        if (EventQueueBackingStoreFileV3.backupExists(checkpointBackupDir) && this.shouldBackup) {
            throw new BadCheckpointException("The checkpoint metadata file does not exist, but a backup exists");
        }
        ProtosFactory.Checkpoint.Builder checkpointBuilder = ProtosFactory.Checkpoint.newBuilder();
        checkpointBuilder.setVersion(this.getVersion());
        checkpointBuilder.setQueueHead(this.getHead());
        checkpointBuilder.setQueueSize(this.getSize());
        checkpointBuilder.setWriteOrderID(this.getLogWriteOrderID());
        FileOutputStream outputStream = new FileOutputStream(this.metaDataFile);
        try {
            checkpointBuilder.build().writeDelimitedTo(outputStream);
            outputStream.getChannel().force(true);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                LOG.warn("Unable to close " + this.metaDataFile, (Throwable)e);
            }
        }
    }

    File getMetaDataFile() {
        return this.metaDataFile;
    }

    @Override
    protected int getVersion() {
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeCheckpointMetaData() throws IOException {
        ProtosFactory.Checkpoint.Builder checkpointBuilder = ProtosFactory.Checkpoint.newBuilder();
        checkpointBuilder.setVersion(this.getVersion());
        checkpointBuilder.setQueueHead(this.getHead());
        checkpointBuilder.setQueueSize(this.getSize());
        checkpointBuilder.setWriteOrderID(this.getLogWriteOrderID());
        for (Integer logFileID : this.logFileIDReferenceCounts.keySet()) {
            int count = ((AtomicInteger)this.logFileIDReferenceCounts.get(logFileID)).get();
            if (count == 0) continue;
            ProtosFactory.ActiveLog.Builder activeLogBuilder = ProtosFactory.ActiveLog.newBuilder();
            activeLogBuilder.setLogFileID(logFileID);
            activeLogBuilder.setCount(count);
            checkpointBuilder.addActiveLogs(activeLogBuilder.build());
        }
        FileOutputStream outputStream = new FileOutputStream(this.metaDataFile);
        try {
            checkpointBuilder.build().writeDelimitedTo(outputStream);
            outputStream.getChannel().force(true);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                LOG.warn("Unable to close " + this.metaDataFile, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void upgrade(EventQueueBackingStoreFileV2 backingStoreV2, File checkpointFile, File metaDataFile) throws IOException {
        int head = backingStoreV2.getHead();
        int size = backingStoreV2.getSize();
        long writeOrderID = backingStoreV2.getLogWriteOrderID();
        Map referenceCounts = backingStoreV2.logFileIDReferenceCounts;
        ProtosFactory.Checkpoint.Builder checkpointBuilder = ProtosFactory.Checkpoint.newBuilder();
        checkpointBuilder.setVersion(3);
        checkpointBuilder.setQueueHead(head);
        checkpointBuilder.setQueueSize(size);
        checkpointBuilder.setWriteOrderID(writeOrderID);
        for (Integer logFileID : referenceCounts.keySet()) {
            int count = ((AtomicInteger)referenceCounts.get(logFileID)).get();
            if (count <= 0) continue;
            ProtosFactory.ActiveLog.Builder activeLogBuilder = ProtosFactory.ActiveLog.newBuilder();
            activeLogBuilder.setLogFileID(logFileID);
            activeLogBuilder.setCount(count);
            checkpointBuilder.addActiveLogs(activeLogBuilder.build());
        }
        FileOutputStream outputStream = new FileOutputStream(metaDataFile);
        try {
            checkpointBuilder.build().writeDelimitedTo(outputStream);
            outputStream.getChannel().force(true);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                LOG.warn("Unable to close " + metaDataFile, (Throwable)e);
            }
        }
        RandomAccessFile checkpointFileHandle = new RandomAccessFile(checkpointFile, "rw");
        try {
            checkpointFileHandle.seek(0L);
            checkpointFileHandle.writeLong(3L);
            checkpointFileHandle.getChannel().force(true);
        }
        finally {
            try {
                checkpointFileHandle.close();
            }
            catch (IOException e) {
                LOG.warn("Unable to close " + checkpointFile, (Throwable)e);
            }
        }
    }
}

