/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectMemoryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DirectMemoryUtils.class);
    private static final String MAX_DIRECT_MEMORY_PARAM = "-XX:MaxDirectMemorySize=";
    private static final long DEFAULT_SIZE = DirectMemoryUtils.getDefaultDirectMemorySize();
    private static final AtomicInteger allocated = new AtomicInteger(0);

    public static ByteBuffer allocate(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Size must be greater than zero");
        long maxDirectMemory = DirectMemoryUtils.getDirectMemorySize();
        long allocatedCurrently = allocated.get();
        LOG.info("Direct Memory Allocation:  Allocation = " + size + ", Allocated = " + allocatedCurrently + ", MaxDirectMemorySize = " + maxDirectMemory + ", Remaining = " + Math.max(0L, maxDirectMemory - allocatedCurrently));
        try {
            ByteBuffer result = ByteBuffer.allocateDirect(size);
            allocated.addAndGet(size);
            return result;
        }
        catch (OutOfMemoryError error) {
            LOG.error("Error allocating " + size + ", you likely want" + " to increase " + MAX_DIRECT_MEMORY_PARAM, (Throwable)error);
            throw error;
        }
    }

    public static void clean(ByteBuffer buffer) throws Exception {
        Preconditions.checkArgument((boolean)buffer.isDirect(), (Object)"buffer isn't direct!");
        Method cleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
        cleanerMethod.setAccessible(true);
        Object cleaner = cleanerMethod.invoke((Object)buffer, new Object[0]);
        Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
        cleanMethod.setAccessible(true);
        cleanMethod.invoke(cleaner, new Object[0]);
        allocated.getAndAdd(-buffer.capacity());
        long maxDirectMemory = DirectMemoryUtils.getDirectMemorySize();
        LOG.info("Direct Memory Deallocation: , Allocated = " + allocated.get() + ", MaxDirectMemorySize = " + maxDirectMemory + ", Remaining = " + Math.max(0L, maxDirectMemory - (long)allocated.get()));
    }

    public static long getDirectMemorySize() {
        RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
        List arguments = Lists.reverse(RuntimemxBean.getInputArguments());
        long multiplier = 1L;
        for (String s : arguments) {
            if (!s.contains(MAX_DIRECT_MEMORY_PARAM)) continue;
            String memSize = s.toLowerCase().replace(MAX_DIRECT_MEMORY_PARAM.toLowerCase(), "").trim();
            if (memSize.contains("k")) {
                multiplier = 1024L;
            } else if (memSize.contains("m")) {
                multiplier = 0x100000L;
            } else if (memSize.contains("g")) {
                multiplier = 0x40000000L;
            }
            memSize = memSize.replaceAll("[^\\d]", "");
            long retValue = Long.parseLong(memSize);
            return retValue * multiplier;
        }
        return DEFAULT_SIZE;
    }

    private static long getDefaultDirectMemorySize() {
        try {
            Class<?> VM = Class.forName("sun.misc.VM");
            Method maxDirectMemory = VM.getDeclaredMethod("maxDirectMemory", new Class[]{null});
            Object result = maxDirectMemory.invoke(null, (Object[])null);
            if (result != null && result instanceof Long) {
                return (Long)result;
            }
        }
        catch (Exception e) {
            LOG.info("Unable to get maxDirectMemory from VM: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
        return Runtime.getRuntime().maxMemory();
    }
}

