/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.FlumeException;
import org.apache.flume.client.avro.ReliableSpoolingFileEventReader;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpoolDirectorySource
extends AbstractSource
implements Configurable,
EventDrivenSource {
    private static final Logger logger = LoggerFactory.getLogger(SpoolDirectorySource.class);
    private static final int POLL_DELAY_MS = 500;
    private String completedSuffix;
    private String spoolDirectory;
    private boolean fileHeader;
    private String fileHeaderKey;
    private int batchSize;
    private String ignorePattern;
    private String trackerDirPath;
    private String deserializerType;
    private Context deserializerContext;
    private String deletePolicy;
    private String inputCharset;
    private SourceCounter sourceCounter;
    ReliableSpoolingFileEventReader reader;

    @Override
    public void start() {
        logger.info("SpoolDirectorySource source starting with directory: {}", (Object)this.spoolDirectory);
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        File directory = new File(this.spoolDirectory);
        try {
            this.reader = new ReliableSpoolingFileEventReader.Builder().spoolDirectory(directory).completedSuffix(this.completedSuffix).ignorePattern(this.ignorePattern).trackerDirPath(this.trackerDirPath).annotateFileName(this.fileHeader).fileNameHeader(this.fileHeaderKey).deserializerType(this.deserializerType).deserializerContext(this.deserializerContext).deletePolicy(this.deletePolicy).inputCharset(this.inputCharset).build();
        }
        catch (IOException ioe) {
            throw new FlumeException("Error instantiating spooling event parser", (Throwable)ioe);
        }
        SpoolDirectoryRunnable runner = new SpoolDirectoryRunnable(this.reader, this.sourceCounter);
        executor.scheduleWithFixedDelay(runner, 0L, 500L, TimeUnit.MILLISECONDS);
        super.start();
        logger.debug("SpoolDirectorySource source started");
        this.sourceCounter.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.sourceCounter.stop();
        logger.info("SpoolDir source {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.sourceCounter);
    }

    @Override
    public void configure(Context context) {
        this.spoolDirectory = context.getString("spoolDir");
        Preconditions.checkState((this.spoolDirectory != null ? 1 : 0) != 0, (Object)"Configuration must specify a spooling directory");
        this.completedSuffix = context.getString("fileSuffix", ".COMPLETED");
        this.deletePolicy = context.getString("deletePolicy", "never");
        this.fileHeader = context.getBoolean("fileHeader", Boolean.valueOf(false));
        this.fileHeaderKey = context.getString("fileHeaderKey", "file");
        this.batchSize = context.getInteger("batchSize", Integer.valueOf(100));
        this.inputCharset = context.getString("inputCharset", "UTF-8");
        this.ignorePattern = context.getString("ignorePattern", "^$");
        this.trackerDirPath = context.getString("trackerDir", ".flumespool");
        this.deserializerType = context.getString("deserializer", "LINE");
        this.deserializerContext = new Context((Map)context.getSubProperties("deserializer."));
        Integer bufferMaxLineLength = context.getInteger("bufferMaxLineLength");
        if (bufferMaxLineLength != null && this.deserializerType != null && this.deserializerType.equalsIgnoreCase("LINE")) {
            this.deserializerContext.put("maxLineLength", bufferMaxLineLength.toString());
        }
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    private class SpoolDirectoryRunnable
    implements Runnable {
        private ReliableSpoolingFileEventReader reader;
        private SourceCounter sourceCounter;

        public SpoolDirectoryRunnable(ReliableSpoolingFileEventReader reader, SourceCounter sourceCounter) {
            this.reader = reader;
            this.sourceCounter = sourceCounter;
        }

        @Override
        public void run() {
            block3: {
                try {
                    List<Event> events;
                    while (!(events = this.reader.readEvents(SpoolDirectorySource.this.batchSize)).isEmpty()) {
                        this.sourceCounter.addToEventReceivedCount(events.size());
                        this.sourceCounter.incrementAppendBatchReceivedCount();
                        SpoolDirectorySource.this.getChannelProcessor().processEventBatch(events);
                        this.reader.commit();
                        this.sourceCounter.addToEventAcceptedCount(events.size());
                        this.sourceCounter.incrementAppendBatchAcceptedCount();
                    }
                }
                catch (Throwable t) {
                    logger.error("Uncaught exception in Runnable", t);
                    if (!(t instanceof Error)) break block3;
                    throw (Error)t;
                }
            }
        }
    }
}

