/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

abstract class AbstractAppendingLongBuffer {
    static final int BLOCK_BITS = 10;
    static final int MAX_PENDING_COUNT = 1024;
    static final int BLOCK_MASK = 1023;
    long[] minValues = new long[16];
    PackedInts.Reader[] deltas = new PackedInts.Reader[16];
    private long deltasBytes;
    int valuesOff = 0;
    long[] pending = new long[1024];
    int pendingOff = 0;

    AbstractAppendingLongBuffer(int initialBlockCount) {
    }

    public final long size() {
        return (long)this.valuesOff * 1024L + (long)this.pendingOff;
    }

    public final void add(long l) {
        if (this.pendingOff == 1024) {
            if (this.deltas.length == this.valuesOff) {
                int newLength = ArrayUtil.oversize(this.valuesOff + 1, 8);
                this.grow(newLength);
            }
            this.packPendingValues();
            if (this.deltas[this.valuesOff] != null) {
                this.deltasBytes += this.deltas[this.valuesOff].ramBytesUsed();
            }
            ++this.valuesOff;
            this.pendingOff = 0;
        }
        this.pending[this.pendingOff++] = l;
    }

    void grow(int newBlockCount) {
        this.minValues = Arrays.copyOf(this.minValues, newBlockCount);
        this.deltas = Arrays.copyOf(this.deltas, newBlockCount);
    }

    abstract void packPendingValues();

    public final long get(long index) {
        if (index < 0L || index >= this.size()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        int block = (int)(index >> 10);
        int element = (int)(index & 0x3FFL);
        return this.get(block, element);
    }

    abstract long get(int var1, int var2);

    abstract Iterator iterator();

    long baseRamBytesUsed() {
        return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 3 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 8;
    }

    public long ramBytesUsed() {
        long bytesUsed = RamUsageEstimator.alignObjectSize(this.baseRamBytesUsed()) + 8L + RamUsageEstimator.sizeOf(this.pending) + RamUsageEstimator.sizeOf(this.minValues) + RamUsageEstimator.alignObjectSize((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * (long)this.deltas.length);
        return bytesUsed + this.deltasBytes;
    }

    abstract class Iterator {
        long[] currentValues;
        int vOff = 0;
        int pOff = 0;

        Iterator() {
            if (AbstractAppendingLongBuffer.this.valuesOff == 0) {
                this.currentValues = AbstractAppendingLongBuffer.this.pending;
            } else {
                this.currentValues = new long[1024];
                this.fillValues();
            }
        }

        abstract void fillValues();

        public final boolean hasNext() {
            return this.vOff < AbstractAppendingLongBuffer.this.valuesOff || this.vOff == AbstractAppendingLongBuffer.this.valuesOff && this.pOff < AbstractAppendingLongBuffer.this.pendingOff;
        }

        public final long next() {
            assert (this.hasNext());
            long result = this.currentValues[this.pOff++];
            if (this.pOff == 1024) {
                ++this.vOff;
                this.pOff = 0;
                if (this.vOff <= AbstractAppendingLongBuffer.this.valuesOff) {
                    this.fillValues();
                }
            }
            return result;
        }
    }
}

