/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;

public abstract class DocIdSet {
    public static final DocIdSet EMPTY_DOCIDSET = new DocIdSet(){

        @Override
        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(){
                boolean exhausted = false;

                @Override
                public int advance(int target) {
                    assert (!this.exhausted);
                    assert (target >= 0);
                    this.exhausted = true;
                    return Integer.MAX_VALUE;
                }

                @Override
                public int docID() {
                    return this.exhausted ? Integer.MAX_VALUE : -1;
                }

                @Override
                public int nextDoc() {
                    assert (!this.exhausted);
                    this.exhausted = true;
                    return Integer.MAX_VALUE;
                }

                @Override
                public long cost() {
                    return 0L;
                }
            };
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public Bits bits() {
            return null;
        }
    };

    public abstract DocIdSetIterator iterator() throws IOException;

    public Bits bits() throws IOException {
        return null;
    }

    public boolean isCacheable() {
        return false;
    }
}

