/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.apache.flume.FlumeException;
import org.apache.flume.api.AbstractRpcClient;
import org.apache.flume.api.FailoverRpcClient;
import org.apache.flume.api.LoadBalancingRpcClient;
import org.apache.flume.api.NettyAvroRpcClient;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientConfigurationConstants;
import org.apache.flume.api.ThriftRpcClient;

public class RpcClientFactory {
    public static RpcClient getInstance(Properties properties) throws FlumeException {
        AbstractRpcClient client;
        Class<?> clazz;
        String type = null;
        type = properties.getProperty("client.type");
        if (type == null || type.isEmpty()) {
            type = ClientType.DEFAULT.getClientClassName();
        }
        try {
            String clientClassType = type;
            ClientType clientType = null;
            try {
                clientType = ClientType.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                clientType = ClientType.OTHER;
            }
            if (!clientType.equals((Object)ClientType.OTHER)) {
                clientClassType = clientType.getClientClassName();
            }
            clazz = Class.forName(clientClassType);
        }
        catch (ClassNotFoundException e) {
            throw new FlumeException("No such client!", e);
        }
        try {
            client = (AbstractRpcClient)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new FlumeException("Cannot instantiate client. Exception follows:", e);
        }
        catch (IllegalAccessException e) {
            throw new FlumeException("Cannot instantiate client. Exception follows:", e);
        }
        client.configure(properties);
        return client;
    }

    public static RpcClient getInstance(File propertiesFile) throws FileNotFoundException, IOException {
        FileReader reader = new FileReader(propertiesFile);
        Properties props = new Properties();
        props.load(reader);
        return RpcClientFactory.getInstance(props);
    }

    @Deprecated
    public static RpcClient getInstance(String hostname, Integer port) throws FlumeException {
        return RpcClientFactory.getDefaultInstance(hostname, port);
    }

    public static RpcClient getDefaultInstance(String hostname, Integer port) throws FlumeException {
        return RpcClientFactory.getDefaultInstance(hostname, port, 0);
    }

    @Deprecated
    public static RpcClient getInstance(String hostname, Integer port, Integer batchSize) throws FlumeException {
        return RpcClientFactory.getDefaultInstance(hostname, port, batchSize);
    }

    public static RpcClient getDefaultInstance(String hostname, Integer port, Integer batchSize) throws FlumeException {
        if (hostname == null) {
            throw new NullPointerException("hostname must not be null");
        }
        if (port == null) {
            throw new NullPointerException("port must not be null");
        }
        if (batchSize == null) {
            throw new NullPointerException("batchSize must not be null");
        }
        Properties props = new Properties();
        props.setProperty("hosts", "h1");
        props.setProperty("hosts.h1", hostname + ":" + port);
        props.setProperty("batch-size", batchSize.toString());
        NettyAvroRpcClient client = new NettyAvroRpcClient();
        client.configure(props);
        return client;
    }

    public static RpcClient getThriftInstance(String hostname, Integer port, Integer batchSize) {
        if (hostname == null) {
            throw new NullPointerException("hostname must not be null");
        }
        if (port == null) {
            throw new NullPointerException("port must not be null");
        }
        if (batchSize == null) {
            throw new NullPointerException("batchSize must not be null");
        }
        Properties props = new Properties();
        props.setProperty("hosts", "h1");
        props.setProperty("hosts.h1", hostname + ":" + port);
        props.setProperty("batch-size", batchSize.toString());
        ThriftRpcClient client = new ThriftRpcClient();
        client.configure(props);
        return client;
    }

    public static RpcClient getThriftInstance(String hostname, Integer port) {
        return RpcClientFactory.getThriftInstance(hostname, port, RpcClientConfigurationConstants.DEFAULT_BATCH_SIZE);
    }

    public static RpcClient getThriftInstance(Properties props) {
        props.setProperty("client.type", ClientType.THRIFT.clientClassName);
        return RpcClientFactory.getInstance(props);
    }

    public static enum ClientType {
        OTHER(null),
        DEFAULT(NettyAvroRpcClient.class.getCanonicalName()),
        DEFAULT_FAILOVER(FailoverRpcClient.class.getCanonicalName()),
        DEFAULT_LOADBALANCE(LoadBalancingRpcClient.class.getCanonicalName()),
        THRIFT(ThriftRpcClient.class.getCanonicalName());

        private final String clientClassName;

        private ClientType(String className) {
            this.clientClassName = className;
        }

        protected String getClientClassName() {
            return this.clientClassName;
        }
    }
}

