/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.base.Validator;
import com.cloudera.cdk.morphline.shaded.com.google.code.regexp.GroupInfo;
import com.cloudera.cdk.morphline.shaded.com.google.code.regexp.Matcher;
import com.cloudera.cdk.morphline.shaded.com.google.code.regexp.Pattern;
import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class GrokBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("grok");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        try {
            return new Grok(config, parent, child, context);
        }
        catch (IOException e) {
            throw new MorphlineCompilationException("Cannot parse", config, e);
        }
    }

    private static final class Grok
    extends AbstractCommand {
        private final Map<String, String> dictionary = new HashMap<String, String>();
        private final Map<String, Pattern> regexes = new HashMap<String, Pattern>();
        private final boolean extract;
        private final boolean extractInPlace;
        private final NumRequiredMatches numRequiredMatches;
        private final boolean findSubstrings;
        private final boolean addEmptyStrings;
        private final Timer elapsedTime;
        private static final boolean ENABLE_FAST_EXTRACTION_PATH = true;

        public Grok(Config config, Command parent, Command child, MorphlineContext context) throws IOException {
            super(config, parent, child, context);
            for (String dictionaryFile : this.getConfigs().getStringList(config, "dictionaryFiles", Collections.EMPTY_LIST)) {
                this.loadDictionaryFile(new File(dictionaryFile));
            }
            String dictionaryString = this.getConfigs().getString(config, "dictionaryString", "");
            this.loadDictionary(new StringReader(dictionaryString));
            this.resolveDictionaryExpressions();
            Config exprConfig = this.getConfigs().getConfig(config, "expressions", ConfigFactory.empty());
            for (Map.Entry entry : exprConfig.root().unwrapped().entrySet()) {
                String expr = entry.getValue().toString();
                expr = this.resolveExpression(expr);
                Pattern pattern = Pattern.compile(expr);
                this.regexes.put((String)entry.getKey(), pattern);
            }
            String extractStr = this.getConfigs().getString(config, "extract", "true");
            this.extractInPlace = extractStr.equals("inplace");
            this.extract = this.extractInPlace ? true : this.getConfigs().getBoolean(config, "extract", true);
            this.numRequiredMatches = (NumRequiredMatches)new Validator().validateEnum(config, this.getConfigs().getString(config, "numRequiredMatches", NumRequiredMatches.atLeastOnce.toString()), NumRequiredMatches.class, new NumRequiredMatches[0]);
            this.findSubstrings = this.getConfigs().getBoolean(config, "findSubstrings", false);
            this.addEmptyStrings = this.getConfigs().getBoolean(config, "addEmptyStrings", false);
            this.validateArguments();
            this.elapsedTime = this.getTimer("elapsedTime");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean doProcess(Record inputRecord) {
            Record outputRecord;
            Timer.Context timerContext = this.elapsedTime.time();
            try {
                Record record = outputRecord = this.extractInPlace || !this.extract ? inputRecord : inputRecord.copy();
                if (this.extractInPlace && (this.regexes.size() > 1 || this.numRequiredMatches != NumRequiredMatches.atLeastOnce) && !this.doMatch(inputRecord, outputRecord, false)) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.doMatch(inputRecord, outputRecord, this.extract)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                timerContext.stop();
            }
            return super.doProcess(outputRecord);
        }

        private boolean doMatch(Record inputRecord, Record outputRecord, boolean doExtract) {
            for (Map.Entry<String, Pattern> regexEntry : this.regexes.entrySet()) {
                Pattern pattern = regexEntry.getValue();
                List values = inputRecord.get(regexEntry.getKey());
                int todo = values.size();
                int minMatches = 1;
                int maxMatches = Integer.MAX_VALUE;
                switch (this.numRequiredMatches) {
                    case once: {
                        maxMatches = 1;
                        break;
                    }
                    case all: {
                        minMatches = todo;
                        break;
                    }
                }
                int numMatches = 0;
                Matcher matcher = null;
                for (Object value : values) {
                    String strValue = value.toString();
                    if (matcher == null) {
                        matcher = pattern.matcher(strValue);
                    } else {
                        matcher.reset(strValue);
                    }
                    if (!this.findSubstrings) {
                        if (matcher.matches()) {
                            if (++numMatches > maxMatches) {
                                return false;
                            }
                            this.extract(outputRecord, pattern, matcher, doExtract);
                        }
                    } else {
                        int previousNumMatches = numMatches;
                        while (matcher.find()) {
                            if (numMatches == previousNumMatches) {
                                if (++numMatches > maxMatches) {
                                    return false;
                                }
                                if (!doExtract && numMatches >= minMatches && maxMatches == Integer.MAX_VALUE) break;
                            }
                            this.extract(outputRecord, pattern, matcher, doExtract);
                        }
                    }
                    --todo;
                    if (doExtract || numMatches < minMatches || maxMatches != Integer.MAX_VALUE) continue;
                    break;
                }
                if (numMatches + todo >= minMatches) continue;
                return false;
            }
            return true;
        }

        private void extract(Record outputRecord, Pattern pattern, Matcher matcher, boolean doExtract) {
            if (doExtract) {
                this.extractFast(outputRecord, pattern, matcher);
            }
        }

        private void extractFast(Record outputRecord, Pattern pattern, Matcher matcher) {
            for (Map.Entry<String, List<GroupInfo>> entry : pattern.groupInfo().entrySet()) {
                String groupName = entry.getKey();
                List<GroupInfo> list = entry.getValue();
                int idx = list.get(0).groupIndex();
                int group = idx > -1 ? idx + 1 : -1;
                String value = matcher.group(group);
                if (value == null || value.length() <= 0 && !this.addEmptyStrings) continue;
                outputRecord.put(groupName, value);
            }
        }

        private void extractSlow(Record outputRecord, Pattern pattern, Matcher matcher) {
            for (String groupName : pattern.groupNames()) {
                String value = matcher.group(groupName);
                if (value == null || value.length() <= 0 && !this.addEmptyStrings) continue;
                outputRecord.put(groupName, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadDictionaryFile(File fileOrDir) throws IOException {
            if (!fileOrDir.exists()) {
                throw new FileNotFoundException("File not found: " + fileOrDir);
            }
            if (!fileOrDir.canRead()) {
                throw new IOException("Insufficient permissions to read file: " + fileOrDir);
            }
            if (fileOrDir.isDirectory()) {
                Object[] files = fileOrDir.listFiles();
                Arrays.sort(files);
                for (Object file : files) {
                    this.loadDictionaryFile((File)file);
                }
            } else {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileOrDir), "UTF-8");
                try {
                    this.loadDictionary(reader);
                }
                finally {
                    Closeables.closeQuietly((Closeable)reader);
                }
            }
        }

        private void loadDictionary(Reader reader) throws IOException {
            for (String line : CharStreams.readLines((Readable)reader)) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                int i = line.indexOf(" ");
                if (i < 0) {
                    throw new MorphlineCompilationException("Dictionary entry line must contain a space to separate name and value: " + line, this.getConfig());
                }
                if (i == 0) {
                    throw new MorphlineCompilationException("Dictionary entry line must contain a name: " + line, this.getConfig());
                }
                String name = line.substring(0, i);
                String value = line.substring(i + 1, line.length()).trim();
                if (value.length() == 0) {
                    throw new MorphlineCompilationException("Dictionary entry line must contain a value: " + line, this.getConfig());
                }
                this.dictionary.put(name, value);
            }
        }

        private void resolveDictionaryExpressions() {
            boolean wasModified = true;
            block0: while (wasModified) {
                wasModified = false;
                for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
                    String resolvedExpr;
                    String expr = entry.getValue();
                    wasModified = expr != (resolvedExpr = this.resolveExpression(expr));
                    if (!wasModified) continue;
                    entry.setValue(resolvedExpr);
                    continue block0;
                }
            }
            this.LOG.debug("dictionary: {}", (Object)Joiner.on((String)"\n").join(new TreeMap<String, String>(this.dictionary).entrySet()));
            for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
                Pattern.compile(entry.getValue());
            }
        }

        private String resolveExpression(String expr) {
            int j;
            int i;
            String PATTERN_START = "%{";
            String PATTERN_END = "}";
            int SEPARATOR = 58;
            while ((i = expr.indexOf(PATTERN_START)) >= 0 && (j = expr.indexOf(PATTERN_END, i + PATTERN_START.length())) >= 0) {
                String refValue;
                String grokPattern = expr.substring(i + PATTERN_START.length(), j);
                int p = grokPattern.indexOf(SEPARATOR);
                String regexName = grokPattern;
                String groupName = null;
                String conversion = null;
                if (p >= 0) {
                    regexName = grokPattern.substring(0, p);
                    groupName = grokPattern.substring(p + 1, grokPattern.length());
                    int q = groupName.indexOf(SEPARATOR);
                    if (q >= 0) {
                        conversion = groupName.substring(q + 1, groupName.length());
                        groupName = groupName.substring(0, q);
                    }
                }
                if ((refValue = this.dictionary.get(regexName)) == null) {
                    throw new MorphlineCompilationException("Missing value for name: " + regexName, this.getConfig());
                }
                if (refValue.contains(PATTERN_START)) break;
                String replacement = refValue;
                if (groupName != null) {
                    replacement = "(?<" + groupName + ">" + refValue + ")";
                }
                expr = new StringBuilder(expr).replace(i, j + PATTERN_END.length(), replacement).toString();
            }
            return expr;
        }

        private static enum NumRequiredMatches {
            atLeastOnce,
            once,
            all;

        }
    }
}

