/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;

public final class GenerateUUIDBuilder
implements CommandBuilder {
    public static final String FIELD_NAME = "field";
    public static final String PRESERVE_EXISTING_NAME = "preserveExisting";
    public static final String PREFIX_NAME = "prefix";

    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("generateUUID");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new GenerateUUID(config, parent, child, context);
    }

    private static final class GenerateUUID
    extends AbstractCommand {
        private final String fieldName;
        private final boolean preserveExisting;
        private final String prefix;

        public GenerateUUID(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            this.fieldName = this.getConfigs().getString(config, GenerateUUIDBuilder.FIELD_NAME, "id");
            this.preserveExisting = this.getConfigs().getBoolean(config, GenerateUUIDBuilder.PRESERVE_EXISTING_NAME, true);
            this.prefix = this.getConfigs().getString(config, GenerateUUIDBuilder.PREFIX_NAME, "");
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            if (!(this.preserveExisting && record.getFields().containsKey((Object)this.fieldName) || !this.isMatch(record))) {
                record.replaceValues(this.fieldName, this.generateUUID());
            }
            return super.doProcess(record);
        }

        protected String getPrefix() {
            return this.prefix;
        }

        protected String generateUUID() {
            return this.getPrefix() + UUID.randomUUID().toString();
        }

        protected boolean isMatch(Record event) {
            return true;
        }
    }
}

