/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdio;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.Validator;
import com.cloudera.cdk.morphline.stdio.AbstractParser;
import com.codahale.metrics.Timer;
import com.typesafe.config.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ReadMultiLineBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("readMultiLine");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadMultiLine(config, parent, child, context);
    }

    private static final class ReadMultiLine
    extends AbstractParser {
        private final Pattern regex;
        private final boolean negate;
        private final What what;
        private final Charset charset;
        private final Timer elapsedTime;

        public ReadMultiLine(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            this.regex = Pattern.compile(this.getConfigs().getString(config, "regex"));
            this.negate = this.getConfigs().getBoolean(config, "negate", false);
            this.charset = this.getConfigs().getCharset(config, "charset", null);
            this.what = (What)new Validator().validateEnum(config, this.getConfigs().getString(config, "what", What.previous.toString()), What.class, new What[0]);
            this.validateArguments();
            this.elapsedTime = this.getTimer("elapsedTime");
        }

        @Override
        protected boolean doProcess(Record inputRecord, InputStream stream) throws IOException {
            String line;
            Timer.Context timerContext = this.elapsedTime.time();
            Charset detectedCharset = this.detectCharset(inputRecord, this.charset);
            InputStreamReader reader = new InputStreamReader(stream, detectedCharset);
            BufferedReader lineReader = new BufferedReader(reader);
            Matcher matcher = this.regex.matcher("");
            StringBuilder lines = null;
            while ((line = lineReader.readLine()) != null) {
                boolean doPrevious;
                if (lines == null) {
                    lines = new StringBuilder(line);
                    continue;
                }
                boolean isMatch = matcher.reset(line).matches();
                if (this.negate) {
                    isMatch = !isMatch;
                }
                boolean bl = doPrevious = this.what == What.previous;
                if (!isMatch) {
                    boolean bl2 = doPrevious = !doPrevious;
                }
                if (doPrevious) {
                    lines.append('\n');
                    lines.append(line);
                    continue;
                }
                if (lines.length() > 0 && !this.flushRecord(inputRecord, lines.toString(), timerContext)) {
                    return false;
                }
                timerContext = this.elapsedTime.time();
                lines.setLength(0);
                lines.append(line);
            }
            if (lines != null && lines.length() > 0) {
                return this.flushRecord(inputRecord, lines.toString(), timerContext);
            }
            return true;
        }

        private boolean flushRecord(Record inputRecord, String lines, Timer.Context timerContext) {
            Record outputRecord = inputRecord.copy();
            ReadMultiLine.removeAttachments(outputRecord);
            outputRecord.replaceValues("message", lines);
            timerContext.stop();
            this.incrementNumRecords();
            return this.getChild().process(outputRecord);
        }

        private static enum What {
            previous,
            next;

        }
    }
}

