/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdio;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.shaded.com.googlecode.jcsv.CSVStrategy;
import com.cloudera.cdk.morphline.shaded.com.googlecode.jcsv.reader.CSVReader;
import com.cloudera.cdk.morphline.shaded.com.googlecode.jcsv.reader.internal.CSVReaderBuilder;
import com.cloudera.cdk.morphline.shaded.com.googlecode.jcsv.reader.internal.DefaultCSVEntryParser;
import com.cloudera.cdk.morphline.stdio.AbstractParser;
import com.typesafe.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ReadCSVBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("readCSV");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadCSV(config, parent, child, context);
    }

    private static final class ReadCSV
    extends AbstractParser {
        private final char separatorChar;
        private final List<String> columnNames;
        private final Charset charset;
        private final boolean ignoreFirstLine;
        private final boolean trim;
        private final char commentChar = (char)35;
        private final char quoteChar = (char)34;
        private final boolean ignoreEmptyLines = true;

        public ReadCSV(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            String separator = this.getConfigs().getString(config, "separator", ",");
            if (separator.length() != 1) {
                throw new MorphlineCompilationException("CSV separator must be one character only: " + separator, config);
            }
            this.separatorChar = separator.charAt(0);
            this.columnNames = this.getConfigs().getStringList(config, "columns");
            this.charset = this.getConfigs().getCharset(config, "charset", null);
            this.ignoreFirstLine = this.getConfigs().getBoolean(config, "ignoreFirstLine", false);
            this.trim = this.getConfigs().getBoolean(config, "trim", true);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record inputRecord, InputStream stream) throws IOException {
            String[] columnValues;
            Charset detectedCharset = this.detectCharset(inputRecord, this.charset);
            InputStreamReader reader = new InputStreamReader(stream, detectedCharset);
            CSVReader csvReader = this.createCSVReader(reader);
            while ((columnValues = (String[])csvReader.readNext()) != null) {
                this.incrementNumRecords();
                Record outputRecord = inputRecord.copy();
                ReadCSV.removeAttachments(outputRecord);
                for (int i = 0; i < columnValues.length; ++i) {
                    if (i >= this.columnNames.size()) {
                        this.columnNames.add("column" + i);
                    }
                    String columnName = this.columnNames.get(i);
                    outputRecord.removeAll(columnName);
                    if (columnName.length() <= 0) continue;
                    outputRecord.put(columnName, this.trim(columnValues[i]));
                }
                if (this.getChild().process(outputRecord)) continue;
                return false;
            }
            return true;
        }

        private String trim(String str) {
            return this.trim ? str.trim() : str;
        }

        private CSVReader createCSVReader(Reader reader) {
            CSVStrategy strategy = new CSVStrategy(this.separatorChar, '\"', '#', this.ignoreFirstLine, true);
            return new CSVReaderBuilder(reader).strategy(strategy).entryParser(new DefaultCSVEntryParser()).build();
        }
    }
}

