/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.base;

import com.cloudera.cdk.morphline.api.Record;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;

public final class FieldExpression {
    private String expression;
    private static final String START_TOKEN = "@{";
    private static final char END_TOKEN = '}';

    public FieldExpression(String expression, Config config) {
        Preconditions.checkNotNull((Object)expression);
        this.expression = expression;
    }

    public List evaluate(Record record) {
        ArrayList results = new ArrayList(1);
        this.evaluate(0, record, new StringBuilder(), results);
        return results;
    }

    private void evaluate(int from, Record record, StringBuilder buf, ArrayList results) {
        int start = this.expression.indexOf(START_TOKEN, from);
        if (start < 0) {
            if (from == 0) {
                results.add(this.expression);
            } else {
                buf.append(this.expression, from, this.expression.length());
                results.add(buf.toString());
            }
        } else {
            int end = this.expression.indexOf(125, start + START_TOKEN.length());
            if (end < 0) {
                throw new IllegalArgumentException("Missing closing token: }");
            }
            buf.append(this.expression, from, start);
            String ref = this.expression.substring(start + START_TOKEN.length(), end);
            if (ref.length() == 0) {
                buf.append(record.toString());
                this.evaluate(end + 1, record, buf, results);
            } else {
                List resolvedValues = record.get(ref);
                if (start == 0 && end + 1 == this.expression.length()) {
                    results.addAll(resolvedValues);
                } else {
                    for (Object value : resolvedValues) {
                        StringBuilder buf2 = new StringBuilder(buf);
                        buf2.append(value.toString());
                        this.evaluate(end + 1, record, buf2, results);
                    }
                }
            }
        }
    }
}

