/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.base;

import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.typesafe.config.Config;
import java.nio.charset.Charset;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class Configs {
    private final Set<String> recognizedArguments = new LinkedHashSet<String>();

    private Set<String> getRecognizedArguments() {
        return this.recognizedArguments;
    }

    private void addRecognizedArgument(String arg) {
        this.recognizedArguments.add(arg);
    }

    public void validateArguments(Config config) {
        Set<String> recognizedArgs = this.getRecognizedArguments();
        for (String key : config.root().keySet()) {
            if (recognizedArgs.contains(key)) continue;
            throw new MorphlineCompilationException("Unrecognized command argument: " + key + ", recognized arguments: " + recognizedArgs, config);
        }
    }

    public String getString(Config config, String path, String defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getString(path);
        }
        return defaults;
    }

    public String getString(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getString(path);
    }

    public List<String> getStringList(Config config, String path, List<String> defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getStringList(path);
        }
        return defaults;
    }

    public List<String> getStringList(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getStringList(path);
    }

    public List<? extends Config> getConfigList(Config config, String path, List<? extends Config> defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getConfigList(path);
        }
        return defaults;
    }

    public List<? extends Config> getConfigList(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getConfigList(path);
    }

    public Config getConfig(Config config, String path, Config defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getConfig(path);
        }
        return defaults;
    }

    public Config getConfig(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getConfig(path);
    }

    public boolean getBoolean(Config config, String path, boolean defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getBoolean(path);
        }
        return defaults;
    }

    public boolean getBoolean(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getBoolean(path);
    }

    public int getInt(Config config, String path, int defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getInt(path);
        }
        return defaults;
    }

    public int getInt(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getInt(path);
    }

    public long getLong(Config config, String path, long defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getLong(path);
        }
        return defaults;
    }

    public long getLong(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getLong(path);
    }

    public double getDouble(Config config, String path, double defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getDouble(path);
        }
        return defaults;
    }

    public double getDouble(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getDouble(path);
    }

    public Charset getCharset(Config config, String path, Charset defaults) {
        String charsetName = this.getString(config, path, defaults == null ? null : defaults.name());
        Charset charset = charsetName == null ? null : Charset.forName(charsetName);
        return charset;
    }
}

