/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import org.hbase.async.BatchableRpc;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.RowLock;
import org.jboss.netty.buffer.ChannelBuffer;

public final class DeleteRequest
extends BatchableRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifiers,
HBaseRpc.IsEdit {
    private static final byte[] DELETE = new byte[]{100, 101, 108, 101, 116, 101};
    static final byte CODE = 31;
    private static final byte[][] DELETE_FAMILY_MARKER = new byte[][]{HBaseClient.EMPTY_ARRAY};
    static final byte[] WHOLE_ROW = new byte[0];
    private final byte[][] qualifiers;

    public DeleteRequest(byte[] table, byte[] key) {
        this(table, key, null, (byte[][])null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, long timestamp) {
        this(table, key, null, (byte[][])null, timestamp, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family) {
        this(table, key, family, (byte[][])null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, long timestamp) {
        this(table, key, family, (byte[][])null, timestamp, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier) {
        Object object;
        if (qualifier == null) {
            object = null;
        } else {
            byte[][] byArrayArray = new byte[1][];
            object = byArrayArray;
            byArrayArray[0] = qualifier;
        }
        this(table, key, family, (byte[][])object, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, long timestamp) {
        Object object;
        if (qualifier == null) {
            object = null;
        } else {
            byte[][] byArrayArray = new byte[1][];
            object = byArrayArray;
            byArrayArray[0] = qualifier;
        }
        this(table, key, family, (byte[][])object, timestamp, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers) {
        this(table, key, family, qualifiers, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, long timestamp) {
        this(table, key, family, qualifiers, timestamp, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, RowLock lock) {
        Object object;
        if (qualifier == null) {
            object = null;
        } else {
            byte[][] byArrayArray = new byte[1][];
            object = byArrayArray;
            byArrayArray[0] = qualifier;
        }
        this(table, key, family, (byte[][])object, Long.MAX_VALUE, lock.id());
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, long timestamp, RowLock lock) {
        Object object;
        if (qualifier == null) {
            object = null;
        } else {
            byte[][] byArrayArray = new byte[1][];
            object = byArrayArray;
            byArrayArray[0] = qualifier;
        }
        this(table, key, family, (byte[][])object, timestamp, lock.id());
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, RowLock lock) {
        this(table, key, family, qualifiers, Long.MAX_VALUE, lock.id());
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, long timestamp, RowLock lock) {
        this(table, key, family, qualifiers, timestamp, lock.id());
    }

    public DeleteRequest(String table, String key) {
        this(table.getBytes(), key.getBytes(), null, (byte[][])null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(String table, String key, String family) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), (byte[][])null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(String table, String key, String family, String qualifier) {
        Object object;
        byte[] byArray = table.getBytes();
        byte[] byArray2 = key.getBytes();
        byte[] byArray3 = family.getBytes();
        if (qualifier == null) {
            object = null;
        } else {
            byte[][] byArrayArray = new byte[1][];
            object = byArrayArray;
            byArrayArray[0] = qualifier.getBytes();
        }
        this(byArray, byArray2, byArray3, (byte[][])object, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(String table, String key, String family, String qualifier, RowLock lock) {
        Object object;
        byte[] byArray = table.getBytes();
        byte[] byArray2 = key.getBytes();
        byte[] byArray3 = family.getBytes();
        if (qualifier == null) {
            object = null;
        } else {
            byte[][] byArrayArray = new byte[1][];
            object = byArrayArray;
            byArrayArray[0] = qualifier.getBytes();
        }
        this(byArray, byArray2, byArray3, (byte[][])object, Long.MAX_VALUE, lock.id());
    }

    public DeleteRequest(byte[] table, KeyValue kv) {
        this(table, kv.key(), kv.family(), (byte[][])new byte[][]{kv.qualifier()}, kv.timestamp(), -1L);
    }

    public DeleteRequest(byte[] table, KeyValue kv, RowLock lock) {
        this(table, kv.key(), kv.family(), (byte[][])new byte[][]{kv.qualifier()}, kv.timestamp(), lock.id());
    }

    private DeleteRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, long timestamp, long lockid) {
        super(DELETE, table, key, family == null ? WHOLE_ROW : family, timestamp, lockid);
        if (family != null) {
            KeyValue.checkFamily(family);
        }
        if (qualifiers != null) {
            if (family == null) {
                throw new IllegalArgumentException("You can't delete specific qualifiers without specifying which family they belong to.  table=" + Bytes.pretty(table) + ", key=" + Bytes.pretty(key));
            }
            for (byte[] qualifier : qualifiers) {
                KeyValue.checkQualifier(qualifier);
            }
            this.qualifiers = qualifiers;
        } else {
            this.qualifiers = DELETE_FAMILY_MARKER;
        }
    }

    @Override
    public byte[] table() {
        return this.table;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public byte[][] qualifiers() {
        return this.qualifiers;
    }

    @Override
    public String toString() {
        return super.toStringWithQualifiers("DeleteRequest", this.family, this.qualifiers);
    }

    @Override
    byte version(byte unused_server_version) {
        return 3;
    }

    @Override
    byte code() {
        return 31;
    }

    @Override
    int numKeyValues() {
        return this.qualifiers.length;
    }

    @Override
    void serializePayload(ChannelBuffer buf) {
        if (this.family == null) {
            return;
        }
        byte type = this.qualifiers == DELETE_FAMILY_MARKER ? (byte)14 : 12;
        for (byte[] qualifier : this.qualifiers) {
            KeyValue.serialize(buf, type, Long.MAX_VALUE, this.key, this.family, qualifier, null);
        }
    }

    private int predictSerializedSize() {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        ++size;
        ++size;
        ++size;
        size += 3;
        size += this.key.length;
        size += 8;
        size += 8;
        size += 4;
        ++size;
        if (this.family == null) {
            return size;
        }
        size += this.family.length;
        return (size += 4) + this.payloadSize();
    }

    @Override
    int payloadSize() {
        if (this.family == WHOLE_ROW) {
            return 0;
        }
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        size += 2;
        size += this.key.length;
        ++size;
        size += this.family.length;
        size += 8;
        ++size;
        size *= this.qualifiers.length;
        for (byte[] qualifier : this.qualifiers) {
            size += qualifier.length;
        }
        return size;
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
        buf.writeInt(2);
        DeleteRequest.writeHBaseByteArray(buf, this.region.name());
        buf.writeByte(31);
        buf.writeByte(31);
        buf.writeByte(1);
        DeleteRequest.writeByteArray(buf, this.key);
        buf.writeLong(this.timestamp);
        buf.writeLong(this.lockid);
        if (this.family == WHOLE_ROW) {
            buf.writeInt(0);
            return buf;
        }
        buf.writeInt(1);
        DeleteRequest.writeByteArray(buf, this.family);
        buf.writeInt(this.qualifiers.length);
        this.serializePayload(buf);
        return buf;
    }
}

